/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.bundle;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dev.sigstore.bundle.Bundle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Bundle.DSSESignature", generator="Immutables")
@Immutable
public final class ImmutableDSSESignature
implements Bundle.DSSESignature {
    private final String payload;
    private final String payloadType;
    private final byte[] signature;

    private ImmutableDSSESignature(String payload, String payloadType, byte[] signature) {
        this.payload = payload;
        this.payloadType = payloadType;
        this.signature = signature;
    }

    @Override
    public String getPayload() {
        return this.payload;
    }

    @Override
    public String getPayloadType() {
        return this.payloadType;
    }

    @Override
    public byte[] getSignature() {
        return (byte[])this.signature.clone();
    }

    public final ImmutableDSSESignature withPayload(String value) {
        String newValue = Objects.requireNonNull(value, "payload");
        if (this.payload.equals(newValue)) {
            return this;
        }
        return new ImmutableDSSESignature(newValue, this.payloadType, this.signature);
    }

    public final ImmutableDSSESignature withPayloadType(String value) {
        String newValue = Objects.requireNonNull(value, "payloadType");
        if (this.payloadType.equals(newValue)) {
            return this;
        }
        return new ImmutableDSSESignature(this.payload, newValue, this.signature);
    }

    public final ImmutableDSSESignature withSignature(byte ... elements) {
        byte[] newValue = (byte[])elements.clone();
        return new ImmutableDSSESignature(this.payload, this.payloadType, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDSSESignature && this.equalTo(0, (ImmutableDSSESignature)another);
    }

    private boolean equalTo(int synthetic, ImmutableDSSESignature another) {
        return this.payload.equals(another.payload) && this.payloadType.equals(another.payloadType) && Arrays.equals(this.signature, another.signature);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.payload.hashCode();
        h += (h << 5) + this.payloadType.hashCode();
        h += (h << 5) + Arrays.hashCode(this.signature);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"DSSESignature").omitNullValues().add("payload", (Object)this.payload).add("payloadType", (Object)this.payloadType).add("signature", (Object)Arrays.toString(this.signature)).toString();
    }

    public static ImmutableDSSESignature copyOf(Bundle.DSSESignature instance) {
        if (instance instanceof ImmutableDSSESignature) {
            return (ImmutableDSSESignature)instance;
        }
        return ImmutableDSSESignature.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Bundle.DSSESignature", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_PAYLOAD = 1L;
        private static final long INIT_BIT_PAYLOAD_TYPE = 2L;
        private static final long INIT_BIT_SIGNATURE = 4L;
        private long initBits = 7L;
        @Nullable
        private String payload;
        @Nullable
        private String payloadType;
        @Nullable
        private byte[] signature;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Bundle.DSSESignature instance) {
            Objects.requireNonNull(instance, "instance");
            this.payload(instance.getPayload());
            this.payloadType(instance.getPayloadType());
            this.signature(instance.getSignature());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder payload(String payload) {
            this.payload = Objects.requireNonNull(payload, "payload");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder payloadType(String payloadType) {
            this.payloadType = Objects.requireNonNull(payloadType, "payloadType");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder signature(byte ... signature) {
            this.signature = (byte[])signature.clone();
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableDSSESignature build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDSSESignature(this.payload, this.payloadType, this.signature);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("payload");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("payloadType");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("signature");
            }
            return "Cannot build DSSESignature, some of required attributes are not set " + attributes;
        }
    }
}

