/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.bundle;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dev.sigstore.bundle.Bundle;
import dev.sigstore.rekor.client.RekorEntry;
import java.security.cert.CertPath;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Bundle", generator="Immutables")
@Immutable
public final class ImmutableBundle
extends Bundle {
    private final String mediaType;
    @Nullable
    private final Bundle.MessageSignature messageSignature;
    @Nullable
    private final Bundle.DSSESignature dSSESignature;
    private final CertPath certPath;
    private final ImmutableList<RekorEntry> entries;
    private final ImmutableList<Bundle.Timestamp> timestamps;
    private volatile transient long lazyInitBitmap;
    private static final long TO_JSON_LAZY_INIT_BIT = 1L;
    private transient String toJson;

    private ImmutableBundle(Builder builder) {
        this.messageSignature = builder.messageSignature;
        this.dSSESignature = builder.dSSESignature;
        this.certPath = builder.certPath;
        this.entries = builder.entries.build();
        this.timestamps = builder.timestamps.build();
        this.mediaType = builder.mediaType != null ? builder.mediaType : Objects.requireNonNull(super.getMediaType(), "mediaType");
    }

    private ImmutableBundle(String mediaType, @Nullable Bundle.MessageSignature messageSignature, @Nullable Bundle.DSSESignature dSSESignature, CertPath certPath, ImmutableList<RekorEntry> entries, ImmutableList<Bundle.Timestamp> timestamps) {
        this.mediaType = mediaType;
        this.messageSignature = messageSignature;
        this.dSSESignature = dSSESignature;
        this.certPath = certPath;
        this.entries = entries;
        this.timestamps = timestamps;
    }

    @Override
    public String getMediaType() {
        return this.mediaType;
    }

    @Override
    public Optional<Bundle.MessageSignature> getMessageSignature() {
        return Optional.ofNullable(this.messageSignature);
    }

    @Override
    public Optional<Bundle.DSSESignature> getDSSESignature() {
        return Optional.ofNullable(this.dSSESignature);
    }

    @Override
    public CertPath getCertPath() {
        return this.certPath;
    }

    public ImmutableList<RekorEntry> getEntries() {
        return this.entries;
    }

    public ImmutableList<Bundle.Timestamp> getTimestamps() {
        return this.timestamps;
    }

    public final ImmutableBundle withMediaType(String value) {
        String newValue = Objects.requireNonNull(value, "mediaType");
        if (this.mediaType.equals(newValue)) {
            return this;
        }
        return ImmutableBundle.validate(new ImmutableBundle(newValue, this.messageSignature, this.dSSESignature, this.certPath, this.entries, this.timestamps));
    }

    public final ImmutableBundle withMessageSignature(Bundle.MessageSignature value) {
        Bundle.MessageSignature newValue = Objects.requireNonNull(value, "messageSignature");
        if (this.messageSignature == newValue) {
            return this;
        }
        return ImmutableBundle.validate(new ImmutableBundle(this.mediaType, newValue, this.dSSESignature, this.certPath, this.entries, this.timestamps));
    }

    public final ImmutableBundle withMessageSignature(Optional<? extends Bundle.MessageSignature> optional) {
        Bundle.MessageSignature value = optional.orElse(null);
        if (this.messageSignature == value) {
            return this;
        }
        return ImmutableBundle.validate(new ImmutableBundle(this.mediaType, value, this.dSSESignature, this.certPath, this.entries, this.timestamps));
    }

    public final ImmutableBundle withDSSESignature(Bundle.DSSESignature value) {
        Bundle.DSSESignature newValue = Objects.requireNonNull(value, "dSSESignature");
        if (this.dSSESignature == newValue) {
            return this;
        }
        return ImmutableBundle.validate(new ImmutableBundle(this.mediaType, this.messageSignature, newValue, this.certPath, this.entries, this.timestamps));
    }

    public final ImmutableBundle withDSSESignature(Optional<? extends Bundle.DSSESignature> optional) {
        Bundle.DSSESignature value = optional.orElse(null);
        if (this.dSSESignature == value) {
            return this;
        }
        return ImmutableBundle.validate(new ImmutableBundle(this.mediaType, this.messageSignature, value, this.certPath, this.entries, this.timestamps));
    }

    public final ImmutableBundle withCertPath(CertPath value) {
        if (this.certPath == value) {
            return this;
        }
        CertPath newValue = Objects.requireNonNull(value, "certPath");
        return ImmutableBundle.validate(new ImmutableBundle(this.mediaType, this.messageSignature, this.dSSESignature, newValue, this.entries, this.timestamps));
    }

    public final ImmutableBundle withEntries(RekorEntry ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return ImmutableBundle.validate(new ImmutableBundle(this.mediaType, this.messageSignature, this.dSSESignature, this.certPath, (ImmutableList<RekorEntry>)newValue, this.timestamps));
    }

    public final ImmutableBundle withEntries(Iterable<? extends RekorEntry> elements) {
        if (this.entries == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return ImmutableBundle.validate(new ImmutableBundle(this.mediaType, this.messageSignature, this.dSSESignature, this.certPath, (ImmutableList<RekorEntry>)newValue, this.timestamps));
    }

    public final ImmutableBundle withTimestamps(Bundle.Timestamp ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return ImmutableBundle.validate(new ImmutableBundle(this.mediaType, this.messageSignature, this.dSSESignature, this.certPath, this.entries, (ImmutableList<Bundle.Timestamp>)newValue));
    }

    public final ImmutableBundle withTimestamps(Iterable<? extends Bundle.Timestamp> elements) {
        if (this.timestamps == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return ImmutableBundle.validate(new ImmutableBundle(this.mediaType, this.messageSignature, this.dSSESignature, this.certPath, this.entries, (ImmutableList<Bundle.Timestamp>)newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBundle && this.equalTo(0, (ImmutableBundle)another);
    }

    private boolean equalTo(int synthetic, ImmutableBundle another) {
        return this.mediaType.equals(another.mediaType) && Objects.equals(this.messageSignature, another.messageSignature) && Objects.equals(this.dSSESignature, another.dSSESignature) && this.certPath.equals(another.certPath) && this.entries.equals(another.entries) && this.timestamps.equals(another.timestamps);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.mediaType.hashCode();
        h += (h << 5) + Objects.hashCode(this.messageSignature);
        h += (h << 5) + Objects.hashCode(this.dSSESignature);
        h += (h << 5) + this.certPath.hashCode();
        h += (h << 5) + this.entries.hashCode();
        h += (h << 5) + this.timestamps.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Bundle").omitNullValues().add("mediaType", (Object)this.mediaType).add("messageSignature", (Object)this.messageSignature).add("dSSESignature", (Object)this.dSSESignature).add("certPath", (Object)this.certPath).add("entries", this.entries).add("timestamps", this.timestamps).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toJson() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableBundle immutableBundle = this;
            synchronized (immutableBundle) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.toJson = Objects.requireNonNull(super.toJson(), "toJson");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.toJson;
    }

    private static ImmutableBundle validate(ImmutableBundle instance) {
        instance.checkAtLeastOneTimestamp();
        instance.checkOnlyOneSignature();
        return instance;
    }

    public static ImmutableBundle copyOf(Bundle instance) {
        if (instance instanceof ImmutableBundle) {
            return (ImmutableBundle)instance;
        }
        return ImmutableBundle.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Bundle", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CERT_PATH = 1L;
        private long initBits = 1L;
        @Nullable
        private String mediaType;
        @Nullable
        private Bundle.MessageSignature messageSignature;
        @Nullable
        private Bundle.DSSESignature dSSESignature;
        @Nullable
        private CertPath certPath;
        private ImmutableList.Builder<RekorEntry> entries = ImmutableList.builder();
        private ImmutableList.Builder<Bundle.Timestamp> timestamps = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Bundle instance) {
            Optional<Bundle.DSSESignature> dSSESignatureOptional;
            Objects.requireNonNull(instance, "instance");
            this.mediaType(instance.getMediaType());
            Optional<Bundle.MessageSignature> messageSignatureOptional = instance.getMessageSignature();
            if (messageSignatureOptional.isPresent()) {
                this.messageSignature(messageSignatureOptional);
            }
            if ((dSSESignatureOptional = instance.getDSSESignature()).isPresent()) {
                this.dSSESignature(dSSESignatureOptional);
            }
            this.certPath(instance.getCertPath());
            this.addAllEntries(instance.getEntries());
            this.addAllTimestamps(instance.getTimestamps());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder mediaType(String mediaType) {
            this.mediaType = Objects.requireNonNull(mediaType, "mediaType");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder messageSignature(Bundle.MessageSignature messageSignature) {
            this.messageSignature = Objects.requireNonNull(messageSignature, "messageSignature");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder messageSignature(Optional<? extends Bundle.MessageSignature> messageSignature) {
            this.messageSignature = messageSignature.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder dSSESignature(Bundle.DSSESignature dSSESignature) {
            this.dSSESignature = Objects.requireNonNull(dSSESignature, "dSSESignature");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder dSSESignature(Optional<? extends Bundle.DSSESignature> dSSESignature) {
            this.dSSESignature = dSSESignature.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder certPath(CertPath certPath) {
            this.certPath = Objects.requireNonNull(certPath, "certPath");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addEntries(RekorEntry element) {
            this.entries.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addEntries(RekorEntry ... elements) {
            this.entries.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder entries(Iterable<? extends RekorEntry> elements) {
            this.entries = ImmutableList.builder();
            return this.addAllEntries(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllEntries(Iterable<? extends RekorEntry> elements) {
            this.entries.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTimestamps(Bundle.Timestamp element) {
            this.timestamps.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTimestamps(Bundle.Timestamp ... elements) {
            this.timestamps.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder timestamps(Iterable<? extends Bundle.Timestamp> elements) {
            this.timestamps = ImmutableList.builder();
            return this.addAllTimestamps(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllTimestamps(Iterable<? extends Bundle.Timestamp> elements) {
            this.timestamps.addAll(elements);
            return this;
        }

        public ImmutableBundle build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableBundle.validate(new ImmutableBundle(this));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("certPath");
            }
            return "Cannot build Bundle, some of required attributes are not set " + attributes;
        }
    }
}

