/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.bundle;

import com.google.common.base.Preconditions;
import dev.sigstore.bundle.BundleParseException;
import dev.sigstore.bundle.BundleReader;
import dev.sigstore.bundle.BundleWriter;
import dev.sigstore.bundle.ImmutableMessageDigest;
import dev.sigstore.bundle.ImmutableMessageSignature;
import dev.sigstore.rekor.client.RekorEntry;
import java.io.Reader;
import java.security.cert.CertPath;
import java.util.List;
import java.util.Optional;
import org.immutables.value.Value;

@Value.Immutable
public abstract class Bundle {
    static final String BUNDLE_V_0_1 = "application/vnd.dev.sigstore.bundle+json;version=0.1";
    static final String BUNDLE_V_0_2 = "application/vnd.dev.sigstore.bundle+json;version=0.2";
    static final String BUNDLE_V_0_3 = "application/vnd.dev.sigstore.bundle+json;version=0.3";
    static final String BUNDLE_V_0_3_1 = "application/vnd.dev.sigstore.bundle.v0.3+json";
    static final List<String> SUPPORTED_MEDIA_TYPES = List.of("application/vnd.dev.sigstore.bundle+json;version=0.1", "application/vnd.dev.sigstore.bundle+json;version=0.2", "application/vnd.dev.sigstore.bundle+json;version=0.3", "application/vnd.dev.sigstore.bundle.v0.3+json");

    @Value.Default
    public String getMediaType() {
        return BUNDLE_V_0_3_1;
    }

    public abstract Optional<MessageSignature> getMessageSignature();

    public abstract Optional<DSSESignature> getDSSESignature();

    @Value.Check
    protected void checkOnlyOneSignature() {
        Preconditions.checkState((this.getDSSESignature().isEmpty() && this.getMessageSignature().isPresent() || this.getDSSESignature().isPresent() && this.getMessageSignature().isEmpty() ? 1 : 0) != 0);
    }

    @Value.Check
    protected void checkAtLeastOneTimestamp() {
        for (RekorEntry entry : this.getEntries()) {
            if (entry.getVerification().getSignedEntryTimestamp() == null) continue;
            return;
        }
        if (this.getTimestamps().size() > 0) {
            return;
        }
        throw new IllegalStateException("No timestamp verification (set, timestamp) was provided");
    }

    public abstract CertPath getCertPath();

    public abstract List<RekorEntry> getEntries();

    public abstract List<Timestamp> getTimestamps();

    public static Bundle from(Reader bundleJson) throws BundleParseException {
        return BundleReader.readBundle(bundleJson);
    }

    @Value.Lazy
    public String toJson() {
        return BundleWriter.writeBundle(this);
    }

    @Value.Immutable
    public static interface Timestamp {
        public byte[] getRfc3161Timestamp();
    }

    @Value.Immutable
    public static interface DSSESignature {
        public String getPayload();

        public String getPayloadType();

        public byte[] getSignature();
    }

    @Value.Immutable
    public static interface MessageDigest {
        public HashAlgorithm getHashAlgorithm();

        public byte[] getDigest();
    }

    @Value.Immutable
    public static interface MessageSignature {
        public Optional<MessageDigest> getMessageDigest();

        public byte[] getSignature();

        public static MessageSignature of(HashAlgorithm algorithm, byte[] digest, byte[] signature) {
            return ImmutableMessageSignature.builder().signature(signature).messageDigest(ImmutableMessageDigest.builder().digest(digest).hashAlgorithm(algorithm).build()).build();
        }
    }

    public static enum HashAlgorithm {
        SHA2_256;

    }
}

