/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore;

import com.google.api.client.util.Preconditions;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import dev.sigstore.KeylessVerificationException;
import dev.sigstore.TrustedRootProvider;
import dev.sigstore.VerificationOptions;
import dev.sigstore.bundle.Bundle;
import dev.sigstore.encryption.certificates.Certificates;
import dev.sigstore.encryption.signers.Verifier;
import dev.sigstore.encryption.signers.Verifiers;
import dev.sigstore.fulcio.client.FulcioCertificateVerifier;
import dev.sigstore.fulcio.client.FulcioVerificationException;
import dev.sigstore.fulcio.client.FulcioVerifier;
import dev.sigstore.rekor.client.RekorEntry;
import dev.sigstore.rekor.client.RekorVerificationException;
import dev.sigstore.rekor.client.RekorVerifier;
import dev.sigstore.trustroot.SigstoreTrustedRoot;
import dev.sigstore.tuf.SigstoreTufClient;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertPath;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.sql.Date;
import java.util.Arrays;
import org.bouncycastle.util.encoders.Hex;

public class KeylessVerifier {
    private final FulcioVerifier fulcioVerifier;
    private final RekorVerifier rekorVerifier;

    private KeylessVerifier(FulcioVerifier fulcioVerifier, RekorVerifier rekorVerifier) {
        this.fulcioVerifier = fulcioVerifier;
        this.rekorVerifier = rekorVerifier;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void verify(Path artifact, Bundle bundle, VerificationOptions options) throws KeylessVerificationException {
        try {
            byte[] artifactDigest = Files.asByteSource((File)artifact.toFile()).hash(Hashing.sha256()).asBytes();
            this.verify(artifactDigest, bundle, options);
        }
        catch (IOException e) {
            throw new KeylessVerificationException("Could not hash provided artifact path: " + artifact);
        }
    }

    public void verify(byte[] artifactDigest, Bundle bundle, VerificationOptions options) throws KeylessVerificationException {
        byte[] bundleDigest;
        if (bundle.getDSSESignature().isPresent()) {
            throw new KeylessVerificationException("Cannot verify DSSE signature based bundles");
        }
        if (bundle.getMessageSignature().isEmpty()) {
            throw new IllegalStateException("Bundle must contain a message signature to verify");
        }
        Bundle.MessageSignature messageSignature = bundle.getMessageSignature().get();
        if (bundle.getEntries().isEmpty()) {
            throw new KeylessVerificationException("Cannot verify bundle without tlog entry");
        }
        if (bundle.getEntries().size() > 1) {
            throw new KeylessVerificationException("Bundle verification expects 1 entry, but found " + bundle.getEntries().size());
        }
        if (!bundle.getTimestamps().isEmpty()) {
            throw new KeylessVerificationException("Cannot verify bundles with timestamp verification material");
        }
        CertPath signingCert = bundle.getCertPath();
        X509Certificate leafCert = Certificates.getLeaf(signingCert);
        if (messageSignature.getMessageDigest().isPresent() && !Arrays.equals(artifactDigest, bundleDigest = messageSignature.getMessageDigest().get().getDigest())) {
            throw new KeylessVerificationException("Provided artifact digest does not match digest used for verification\nprovided(hex) : " + Hex.toHexString((byte[])artifactDigest) + "\nverification  : " + Hex.toHexString((byte[])bundleDigest));
        }
        try {
            this.fulcioVerifier.verifySigningCertificate(signingCert);
        }
        catch (FulcioVerificationException | IOException ex) {
            throw new KeylessVerificationException("Fulcio certificate was not valid: " + ex.getMessage(), ex);
        }
        if (options.getCertificateIdentities().size() > 0) {
            try {
                new FulcioCertificateVerifier().verifyCertificateMatches(leafCert, options.getCertificateIdentities());
            }
            catch (FulcioVerificationException fve) {
                throw new KeylessVerificationException("Could not verify certificate identities: " + fve.getMessage(), fve);
            }
        }
        byte[] signature = messageSignature.getSignature();
        RekorEntry rekorEntry = bundle.getEntries().get(0);
        try {
            this.rekorVerifier.verifyEntry(rekorEntry);
        }
        catch (RekorVerificationException ex) {
            throw new KeylessVerificationException("Rekor entry signature was not valid", ex);
        }
        java.util.Date entryTime = Date.from(rekorEntry.getIntegratedTimeInstant());
        try {
            leafCert.checkValidity(entryTime);
        }
        catch (CertificateNotYetValidException e) {
            throw new KeylessVerificationException("Signing time was before certificate validity", e);
        }
        catch (CertificateExpiredException e) {
            throw new KeylessVerificationException("Signing time was after certificate expiry", e);
        }
        PublicKey publicKey = leafCert.getPublicKey();
        try {
            Verifier verifier = Verifiers.newVerifier(publicKey);
            if (!verifier.verifyDigest(artifactDigest, signature)) {
                throw new KeylessVerificationException("Artifact signature was not valid");
            }
        }
        catch (InvalidKeyException | NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
        catch (SignatureException ex) {
            throw new KeylessVerificationException("Signature could not be processed: " + ex.getMessage(), ex);
        }
    }

    public static class Builder {
        private TrustedRootProvider trustedRootProvider;

        public KeylessVerifier build() throws InvalidAlgorithmParameterException, CertificateException, InvalidKeySpecException, NoSuchAlgorithmException, IOException, InvalidKeyException {
            Preconditions.checkNotNull((Object)this.trustedRootProvider);
            SigstoreTrustedRoot trustedRoot = this.trustedRootProvider.get();
            FulcioVerifier fulcioVerifier = FulcioVerifier.newFulcioVerifier(trustedRoot);
            RekorVerifier rekorVerifier = RekorVerifier.newRekorVerifier(trustedRoot);
            return new KeylessVerifier(fulcioVerifier, rekorVerifier);
        }

        public Builder sigstorePublicDefaults() {
            SigstoreTufClient.Builder sigstoreTufClientBuilder = SigstoreTufClient.builder().usePublicGoodInstance();
            this.trustedRootProvider = TrustedRootProvider.from(sigstoreTufClientBuilder);
            return this;
        }

        public Builder sigstoreStagingDefaults() {
            SigstoreTufClient.Builder sigstoreTufClientBuilder = SigstoreTufClient.builder().useStagingInstance();
            this.trustedRootProvider = TrustedRootProvider.from(sigstoreTufClientBuilder);
            return this;
        }

        public Builder trustedRootProvider(TrustedRootProvider trustedRootProvider) {
            this.trustedRootProvider = trustedRootProvider;
            return this;
        }
    }
}

