/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dev.sigstore.OidcIdentity;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="OidcIdentity", generator="Immutables")
@Immutable
public final class ImmutableOidcIdentity
implements OidcIdentity {
    private final String identity;
    private final String issuer;

    private ImmutableOidcIdentity(String identity, String issuer) {
        this.identity = identity;
        this.issuer = issuer;
    }

    @Override
    public String getIdentity() {
        return this.identity;
    }

    @Override
    public String getIssuer() {
        return this.issuer;
    }

    public final ImmutableOidcIdentity withIdentity(String value) {
        String newValue = Objects.requireNonNull(value, "identity");
        if (this.identity.equals(newValue)) {
            return this;
        }
        return new ImmutableOidcIdentity(newValue, this.issuer);
    }

    public final ImmutableOidcIdentity withIssuer(String value) {
        String newValue = Objects.requireNonNull(value, "issuer");
        if (this.issuer.equals(newValue)) {
            return this;
        }
        return new ImmutableOidcIdentity(this.identity, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableOidcIdentity && this.equalTo(0, (ImmutableOidcIdentity)another);
    }

    private boolean equalTo(int synthetic, ImmutableOidcIdentity another) {
        return this.identity.equals(another.identity) && this.issuer.equals(another.issuer);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identity.hashCode();
        h += (h << 5) + this.issuer.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"OidcIdentity").omitNullValues().add("identity", (Object)this.identity).add("issuer", (Object)this.issuer).toString();
    }

    public static ImmutableOidcIdentity copyOf(OidcIdentity instance) {
        if (instance instanceof ImmutableOidcIdentity) {
            return (ImmutableOidcIdentity)instance;
        }
        return ImmutableOidcIdentity.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="OidcIdentity", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_IDENTITY = 1L;
        private static final long INIT_BIT_ISSUER = 2L;
        private long initBits = 3L;
        @Nullable
        private String identity;
        @Nullable
        private String issuer;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(OidcIdentity instance) {
            Objects.requireNonNull(instance, "instance");
            this.identity(instance.getIdentity());
            this.issuer(instance.getIssuer());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder identity(String identity) {
            this.identity = Objects.requireNonNull(identity, "identity");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder issuer(String issuer) {
            this.issuer = Objects.requireNonNull(issuer, "issuer");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableOidcIdentity build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableOidcIdentity(this.identity, this.issuer);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("identity");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("issuer");
            }
            return "Cannot build OidcIdentity, some of required attributes are not set " + attributes;
        }
    }
}

