/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dev.sigstore.VerificationOptions;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="VerificationOptions.CertificateIdentity", generator="Immutables")
@Immutable
public final class ImmutableCertificateIdentity
implements VerificationOptions.CertificateIdentity {
    private final String issuer;
    private final String subjectAlternativeName;
    private final ImmutableMap<String, String> other;

    private ImmutableCertificateIdentity(String issuer, String subjectAlternativeName, ImmutableMap<String, String> other) {
        this.issuer = issuer;
        this.subjectAlternativeName = subjectAlternativeName;
        this.other = other;
    }

    @Override
    public String getIssuer() {
        return this.issuer;
    }

    @Override
    public String getSubjectAlternativeName() {
        return this.subjectAlternativeName;
    }

    public ImmutableMap<String, String> getOther() {
        return this.other;
    }

    public final ImmutableCertificateIdentity withIssuer(String value) {
        String newValue = Objects.requireNonNull(value, "issuer");
        if (this.issuer.equals(newValue)) {
            return this;
        }
        return new ImmutableCertificateIdentity(newValue, this.subjectAlternativeName, this.other);
    }

    public final ImmutableCertificateIdentity withSubjectAlternativeName(String value) {
        String newValue = Objects.requireNonNull(value, "subjectAlternativeName");
        if (this.subjectAlternativeName.equals(newValue)) {
            return this;
        }
        return new ImmutableCertificateIdentity(this.issuer, newValue, this.other);
    }

    public final ImmutableCertificateIdentity withOther(Map<String, ? extends String> entries) {
        if (this.other == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableCertificateIdentity(this.issuer, this.subjectAlternativeName, (ImmutableMap<String, String>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCertificateIdentity && this.equalTo(0, (ImmutableCertificateIdentity)another);
    }

    private boolean equalTo(int synthetic, ImmutableCertificateIdentity another) {
        return this.issuer.equals(another.issuer) && this.subjectAlternativeName.equals(another.subjectAlternativeName) && this.other.equals(another.other);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.issuer.hashCode();
        h += (h << 5) + this.subjectAlternativeName.hashCode();
        h += (h << 5) + this.other.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CertificateIdentity").omitNullValues().add("issuer", (Object)this.issuer).add("subjectAlternativeName", (Object)this.subjectAlternativeName).add("other", this.other).toString();
    }

    public static ImmutableCertificateIdentity copyOf(VerificationOptions.CertificateIdentity instance) {
        if (instance instanceof ImmutableCertificateIdentity) {
            return (ImmutableCertificateIdentity)instance;
        }
        return ImmutableCertificateIdentity.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="VerificationOptions.CertificateIdentity", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ISSUER = 1L;
        private static final long INIT_BIT_SUBJECT_ALTERNATIVE_NAME = 2L;
        private long initBits = 3L;
        @Nullable
        private String issuer;
        @Nullable
        private String subjectAlternativeName;
        private ImmutableMap.Builder<String, String> other = ImmutableMap.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(VerificationOptions.CertificateIdentity instance) {
            Objects.requireNonNull(instance, "instance");
            this.issuer(instance.getIssuer());
            this.subjectAlternativeName(instance.getSubjectAlternativeName());
            this.putAllOther(instance.getOther());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder issuer(String issuer) {
            this.issuer = Objects.requireNonNull(issuer, "issuer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder subjectAlternativeName(String subjectAlternativeName) {
            this.subjectAlternativeName = Objects.requireNonNull(subjectAlternativeName, "subjectAlternativeName");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putOther(String key, String value) {
            this.other.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putOther(Map.Entry<String, ? extends String> entry) {
            this.other.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder other(Map<String, ? extends String> entries) {
            this.other = ImmutableMap.builder();
            return this.putAllOther(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllOther(Map<String, ? extends String> entries) {
            this.other.putAll(entries);
            return this;
        }

        public ImmutableCertificateIdentity build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCertificateIdentity(this.issuer, this.subjectAlternativeName, (ImmutableMap<String, String>)this.other.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("issuer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("subjectAlternativeName");
            }
            return "Cannot build CertificateIdentity, some of required attributes are not set " + attributes;
        }
    }
}

