(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'stdx-kt-stdx-core-js-legacy'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'stdx-kt-stdx-core-js-legacy'.");
    }root['stdx-kt-stdx-core-js-legacy'] = factory(typeof this['stdx-kt-stdx-core-js-legacy'] === 'undefined' ? {} : this['stdx-kt-stdx-core-js-legacy'], kotlin);
  }
}(this, function (_, Kotlin) {
  'use strict';
  var $$importsForInline$$ = _.$$importsForInline$$ || (_.$$importsForInline$$ = {});
  var defineInlineFunction = Kotlin.defineInlineFunction;
  var unboxChar = Kotlin.unboxChar;
  var isDigit = Kotlin.kotlin.text.isDigit_myv2d0$;
  var wrapFunction = Kotlin.wrapFunction;
  var chunked = Kotlin.kotlin.text.chunked_94bcnn$;
  var ArrayList_init = Kotlin.kotlin.collections.ArrayList_init_ww73n8$;
  var joinToString = Kotlin.kotlin.collections.joinToString_fmv235$;
  var split = Kotlin.kotlin.text.split_o64adg$;
  var iterator = Kotlin.kotlin.text.iterator_gw00vp$;
  var toBoxedChar = Kotlin.toBoxedChar;
  var isBlank = Kotlin.kotlin.text.isBlank_gw00vp$;
  var Collection = Kotlin.kotlin.collections.Collection;
  var ArrayList_init_0 = Kotlin.kotlin.collections.ArrayList_init_287e2$;
  var addAll = Kotlin.kotlin.collections.addAll_ipc267$;
  var Regex_init = Kotlin.kotlin.text.Regex_init_61zpoe$;
  var computeIfAbsent = defineInlineFunction('stdx-kt-stdx-core-js-legacy.dev.schlaubi.stdx.core.computeIfAbsent_9wl75a$', function ($receiver, key, initializer) {
    var v1 = $receiver.get_11rb$(key);
    if (v1 == null) {
      var v2 = initializer();
      $receiver.put_xwzc9p$(key, v2);
      return v2;
    }return v1;
  });
  var onEach = defineInlineFunction('stdx-kt-stdx-core-js-legacy.dev.schlaubi.stdx.core.onEach_i7id1t$', function ($receiver, action) {
    var tmp$;
    tmp$ = $receiver.iterator();
    while (tmp$.hasNext()) {
      var element = tmp$.next();
      action(element);
    }
  });
  var LIST_SEPARATOR_REGEX;
  function isNumeric($receiver) {
    var all$result;
    all$break: do {
      var tmp$;
      tmp$ = iterator($receiver);
      while (tmp$.hasNext()) {
        var element = unboxChar(tmp$.next());
        if (!isDigit(unboxChar(toBoxedChar(element)))) {
          all$result = false;
          break all$break;
        }}
      all$result = true;
    }
     while (false);
    return all$result;
  }
  var isNotNumeric = defineInlineFunction('stdx-kt-stdx-core-js-legacy.dev.schlaubi.stdx.core.isNotNumeric_pdl1vz$', wrapFunction(function () {
    var isNumeric = _.dev.schlaubi.stdx.core.isNumeric_pdl1vz$;
    return function ($receiver) {
      return !isNumeric($receiver);
    };
  }));
  function nullIfBlank($receiver) {
    return isBlank($receiver) ? null : $receiver;
  }
  var isNotNullOrEmpty = defineInlineFunction('stdx-kt-stdx-core-js-legacy.dev.schlaubi.stdx.core.isNotNullOrEmpty_5cw0du$', function ($receiver) {
    return !($receiver == null || $receiver.length === 0);
  });
  var isNotNullOrBlank = defineInlineFunction('stdx-kt-stdx-core-js-legacy.dev.schlaubi.stdx.core.isNotNullOrBlank_5cw0du$', wrapFunction(function () {
    var isBlank = Kotlin.kotlin.text.isBlank_gw00vp$;
    return function ($receiver) {
      return !($receiver == null || isBlank($receiver));
    };
  }));
  function paginate$addCurrentList(closure$paged, closure$currentList, closure$separator) {
    return function () {
      closure$paged.add_11rb$(joinToString(closure$currentList.v, closure$separator));
    };
  }
  function paginate($receiver, pageLength, separator) {
    if (separator === void 0)
      separator = '\n';
    var any$result;
    any$break: do {
      var tmp$;
      if (Kotlin.isType($receiver, Collection) && $receiver.isEmpty()) {
        any$result = false;
        break any$break;
      }tmp$ = $receiver.iterator();
      while (tmp$.hasNext()) {
        var element = tmp$.next();
        if (element.length > pageLength) {
          any$result = true;
          break any$break;
        }}
      any$result = false;
    }
     while (false);
    if (any$result) {
      var destination = ArrayList_init_0();
      var tmp$_0;
      tmp$_0 = $receiver.iterator();
      while (tmp$_0.hasNext()) {
        var element_0 = tmp$_0.next();
        var list = chunked(element_0, pageLength);
        addAll(destination, list);
      }
      return paginate(destination, pageLength, separator);
    }var currentLength = 0;
    var currentList = {v: ArrayList_init(10)};
    var paged = ArrayList_init($receiver.size);
    var iterator = $receiver.iterator();
    var addCurrentList = paginate$addCurrentList(paged, currentList, separator);
    while (iterator.hasNext()) {
      var line = iterator.next();
      var fullLength = line.length + separator.length | 0;
      if ((currentLength + fullLength | 0) > pageLength) {
        addCurrentList();
        currentList.v = ArrayList_init(10);
        currentLength = 0;
      }currentList.v.add_11rb$(line);
      currentLength = currentLength + fullLength | 0;
    }
    addCurrentList();
    return paged;
  }
  function splitList($receiver) {
    return LIST_SEPARATOR_REGEX.split_905azu$($receiver, 0);
  }
  function splitListStrict($receiver) {
    return split($receiver, Kotlin.charArrayOf(44));
  }
  function limit($receiver, maxLength, truncate) {
    if (truncate === void 0)
      truncate = '...';
    if ($receiver.length > maxLength) {
      var endIndex = maxLength - truncate.length | 0;
      return $receiver.substring(0, endIndex) + truncate;
    } else {
      return $receiver;
    }
  }
  $$importsForInline$$['stdx-kt-stdx-core-js-legacy'] = _;
  var package$dev = _.dev || (_.dev = {});
  var package$schlaubi = package$dev.schlaubi || (package$dev.schlaubi = {});
  var package$stdx = package$schlaubi.stdx || (package$schlaubi.stdx = {});
  var package$core = package$stdx.core || (package$stdx.core = {});
  package$core.computeIfAbsent_9wl75a$ = computeIfAbsent;
  package$core.onEach_i7id1t$ = onEach;
  package$core.isNumeric_pdl1vz$ = isNumeric;
  package$core.isNotNumeric_pdl1vz$ = isNotNumeric;
  package$core.nullIfBlank_pdl1vz$ = nullIfBlank;
  package$core.isNotNullOrEmpty_5cw0du$ = isNotNullOrEmpty;
  package$core.isNotNullOrBlank_5cw0du$ = isNotNullOrBlank;
  package$core.paginate_ej4n1s$ = paginate;
  package$core.splitList_pdl1vz$ = splitList;
  package$core.splitListStrict_pdl1vz$ = splitListStrict;
  package$core.limit_eu8zx7$ = limit;
  LIST_SEPARATOR_REGEX = Regex_init(',\\s*');
  Kotlin.defineModule('stdx-kt-stdx-core-js-legacy', _);
  return _;
}));

//# sourceMappingURL=stdx-kt-stdx-core-js-legacy.js.map
