/*
 * Decompiled with CFR 0.152.
 */
package dev.responsive.kafka.internal.db;

import dev.responsive.kafka.internal.db.RemoteWriter;
import dev.responsive.kafka.internal.db.TTDTable;
import dev.responsive.kafka.internal.stores.RemoteWriteResult;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public class TTDWriter<K, P>
implements RemoteWriter<K, P> {
    private final TTDTable<K> table;
    private final P tablePartition;

    public TTDWriter(TTDTable<K> table, P tablePartition) {
        this.table = table;
        this.tablePartition = tablePartition;
    }

    public void insert(K key, byte[] value, long epochMillis) {
        this.table.insert(0, key, value, epochMillis);
    }

    public void delete(K key) {
        this.table.delete(0, key);
    }

    public CompletionStage<RemoteWriteResult<P>> flush() {
        return CompletableFuture.completedStage(RemoteWriteResult.success(this.tablePartition));
    }
}

