/*
 * Decompiled with CFR 0.152.
 */
package dev.responsive.kafka.internal.db;

import com.datastax.oss.driver.api.core.cql.BoundStatement;
import dev.responsive.kafka.internal.clients.TTDCassandraClient;
import dev.responsive.kafka.internal.db.CassandraClient;
import dev.responsive.kafka.internal.db.RemoteWindowedTable;
import dev.responsive.kafka.internal.db.RemoteWriter;
import dev.responsive.kafka.internal.db.TTDTable;
import dev.responsive.kafka.internal.db.TTDWriter;
import dev.responsive.kafka.internal.db.WindowFlushManager;
import dev.responsive.kafka.internal.db.partitioning.SegmentPartitioner;
import dev.responsive.kafka.internal.db.partitioning.TablePartitioner;
import dev.responsive.kafka.internal.db.spec.CassandraTableSpec;
import dev.responsive.kafka.internal.stores.RemoteWriteResult;
import dev.responsive.kafka.internal.stores.WindowStoreStub;
import dev.responsive.kafka.internal.utils.WindowedKey;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.state.KeyValueIterator;

public class TTDWindowedTable
extends TTDTable<WindowedKey>
implements RemoteWindowedTable<BoundStatement> {
    private final String name;
    private final WindowStoreStub stub;
    private final SegmentPartitioner partitioner;

    public static TTDWindowedTable create(CassandraTableSpec spec, CassandraClient client) {
        return new TTDWindowedTable(spec, (TTDCassandraClient)client);
    }

    public TTDWindowedTable(CassandraTableSpec spec, TTDCassandraClient client) {
        super(client);
        this.name = spec.tableName();
        this.stub = new WindowStoreStub();
        this.partitioner = (SegmentPartitioner)spec.partitioner();
    }

    public String name() {
        return this.name;
    }

    public WindowFlushManager init(int kafkaPartition) {
        return new TTDWindowFlushManager(this, kafkaPartition, this.partitioner);
    }

    public BoundStatement insert(int kafkaPartition, WindowedKey key, byte[] value, long epochMillis) {
        this.stub.put(key, value);
        return null;
    }

    public BoundStatement delete(int kafkaPartition, WindowedKey key) {
        this.stub.delete(key);
        return null;
    }

    public byte[] fetch(int kafkaPartition, Bytes key, long windowStart) {
        return this.stub.fetch(key, windowStart);
    }

    public KeyValueIterator<WindowedKey, byte[]> fetch(int kafkaPartition, Bytes key, long timeFrom, long timeTo) {
        return this.stub.fetch(key, timeFrom, timeTo);
    }

    public KeyValueIterator<WindowedKey, byte[]> backFetch(int kafkaPartition, Bytes key, long timeFrom, long timeTo) {
        return this.stub.backFetch(key, timeFrom, timeTo);
    }

    public KeyValueIterator<WindowedKey, byte[]> fetchRange(int kafkaPartition, Bytes fromKey, Bytes toKey, long timeFrom, long timeTo) {
        return this.stub.fetchRange(fromKey, toKey, timeFrom, timeTo);
    }

    public KeyValueIterator<WindowedKey, byte[]> backFetchRange(int kafkaPartition, Bytes fromKey, Bytes toKey, long timeFrom, long timeTo) {
        return this.stub.backFetchRange(fromKey, toKey, timeFrom, timeTo);
    }

    public KeyValueIterator<WindowedKey, byte[]> fetchAll(int kafkaPartition, long timeFrom, long timeTo) {
        return this.stub.fetchAll(timeFrom, timeTo);
    }

    public KeyValueIterator<WindowedKey, byte[]> backFetchAll(int kafkaPartition, long timeFrom, long timeTo) {
        return this.stub.backFetchAll(timeFrom, timeTo);
    }

    @Override
    public long count() {
        return 0L;
    }

    private static class TTDWindowFlushManager
    extends WindowFlushManager {
        private final String logPrefix;
        private final TTDWindowedTable table;
        private final SegmentPartitioner partitioner;

        public TTDWindowFlushManager(TTDWindowedTable table, int kafkaPartition, SegmentPartitioner partitioner) {
            super(table.name(), kafkaPartition, partitioner, 0L);
            this.table = table;
            this.partitioner = partitioner;
            this.logPrefix = String.format("%s TTDWindowFlushManager ", table.name());
        }

        public String tableName() {
            return this.table.name();
        }

        public TablePartitioner<WindowedKey, SegmentPartitioner.SegmentPartition> partitioner() {
            return this.partitioner;
        }

        public RemoteWriter<WindowedKey, SegmentPartitioner.SegmentPartition> createWriter(SegmentPartitioner.SegmentPartition tablePartition) {
            return new TTDWriter<WindowedKey, SegmentPartitioner.SegmentPartition>(this.table, tablePartition);
        }

        public String failedFlushInfo(long batchOffset, SegmentPartitioner.SegmentPartition failedTablePartition) {
            return "";
        }

        public String logPrefix() {
            return this.logPrefix;
        }

        protected RemoteWriteResult<SegmentPartitioner.SegmentPartition> updateOffsetAndStreamTime(long consumedOffset, long streamTime) {
            return null;
        }

        protected RemoteWriteResult<SegmentPartitioner.SegmentPartition> createSegment(SegmentPartitioner.SegmentPartition partition) {
            return null;
        }

        protected RemoteWriteResult<SegmentPartitioner.SegmentPartition> deleteSegment(SegmentPartitioner.SegmentPartition partition) {
            return null;
        }
    }
}

