/*
 * Decompiled with CFR 0.152.
 */
package dev.responsive.kafka.internal.db;

import com.datastax.oss.driver.api.core.cql.BoundStatement;
import dev.responsive.kafka.internal.clients.TTDCassandraClient;
import dev.responsive.kafka.internal.db.CassandraClient;
import dev.responsive.kafka.internal.db.KVFlushManager;
import dev.responsive.kafka.internal.db.RemoteKVTable;
import dev.responsive.kafka.internal.db.RemoteWriter;
import dev.responsive.kafka.internal.db.TTDTable;
import dev.responsive.kafka.internal.db.TTDWriter;
import dev.responsive.kafka.internal.db.partitioning.TablePartitioner;
import dev.responsive.kafka.internal.db.spec.CassandraTableSpec;
import dev.responsive.kafka.internal.db.spec.DelegatingTableSpec;
import dev.responsive.kafka.internal.db.spec.TtlTableSpec;
import dev.responsive.kafka.internal.stores.KVStoreStub;
import dev.responsive.kafka.internal.stores.RemoteWriteResult;
import java.time.Duration;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.state.KeyValueIterator;

public class TTDKeyValueTable
extends TTDTable<Bytes>
implements RemoteKVTable<BoundStatement> {
    private final String name;
    private final KVStoreStub stub;

    public static TTDKeyValueTable create(CassandraTableSpec spec, CassandraClient client) {
        return new TTDKeyValueTable(spec, (TTDCassandraClient)client);
    }

    public TTDKeyValueTable(CassandraTableSpec spec, TTDCassandraClient client) {
        super(client);
        this.name = spec.tableName();
        Duration ttl = null;
        CassandraTableSpec maybeTtlSpec = spec;
        while (maybeTtlSpec instanceof DelegatingTableSpec) {
            if (maybeTtlSpec instanceof TtlTableSpec) {
                ttl = ((TtlTableSpec)maybeTtlSpec).ttl();
                break;
            }
            maybeTtlSpec = ((DelegatingTableSpec)maybeTtlSpec).delegate();
        }
        this.stub = new KVStoreStub(ttl, this.time);
    }

    public KVFlushManager init(int kafkaPartition) {
        return new TTDKeyValueFlushManager(this);
    }

    @Override
    public long count() {
        return this.stub.count();
    }

    public String name() {
        return this.name;
    }

    public BoundStatement insert(int kafkaPartition, Bytes key, byte[] value, long epochMillis) {
        this.stub.put(key, value);
        return null;
    }

    public BoundStatement delete(int kafkaPartition, Bytes key) {
        this.stub.delete(key);
        return null;
    }

    public byte[] get(int kafkaPartition, Bytes key, long minValidTs) {
        return this.stub.get(key);
    }

    public KeyValueIterator<Bytes, byte[]> range(int kafkaPartition, Bytes from, Bytes to, long minValidTs) {
        return this.stub.range(from, to);
    }

    public KeyValueIterator<Bytes, byte[]> all(int kafkaPartition, long minValidTs) {
        return this.stub.all();
    }

    public long approximateNumEntries(int kafkaPartition) {
        return this.client.count(this.name(), kafkaPartition);
    }

    private static class TTDKeyValueFlushManager
    extends KVFlushManager {
        private final String logPrefix;
        private final TTDKeyValueTable table;

        public TTDKeyValueFlushManager(TTDKeyValueTable table) {
            this.table = table;
            this.logPrefix = String.format("%s TTDKeyValueFlushManager ", table.name());
        }

        public String tableName() {
            return this.table.name();
        }

        public TablePartitioner<Bytes, Integer> partitioner() {
            return TablePartitioner.defaultPartitioner();
        }

        public RemoteWriter<Bytes, Integer> createWriter(Integer tablePartition) {
            return new TTDWriter<Bytes, Integer>(this.table, tablePartition);
        }

        public String failedFlushInfo(long batchOffset, Integer failedTablePartition) {
            return "";
        }

        public String logPrefix() {
            return this.logPrefix;
        }

        public RemoteWriteResult<Integer> updateOffset(long consumedOffset) {
            return RemoteWriteResult.success(null);
        }
    }
}

