/*
 * Decompiled with CFR 0.152.
 */
package dev.responsive.kafka.internal.clients;

import com.datastax.oss.driver.api.core.cql.AsyncResultSet;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import dev.responsive.kafka.api.config.ResponsiveConfig;
import dev.responsive.kafka.internal.clients.TTDMockAdmin;
import dev.responsive.kafka.internal.db.CassandraClient;
import dev.responsive.kafka.internal.db.RemoteKVTable;
import dev.responsive.kafka.internal.db.RemoteWindowedTable;
import dev.responsive.kafka.internal.db.TTDKeyValueTable;
import dev.responsive.kafka.internal.db.TTDWindowedTable;
import dev.responsive.kafka.internal.db.TableCache;
import dev.responsive.kafka.internal.stores.ResponsiveStoreRegistry;
import dev.responsive.kafka.internal.utils.RemoteMonitor;
import java.time.Duration;
import java.util.Map;
import java.util.OptionalInt;
import java.util.concurrent.CompletionStage;
import org.apache.kafka.common.utils.Time;

public class TTDCassandraClient
extends CassandraClient {
    private final Time time;
    private final ResponsiveStoreRegistry storeRegistry = new ResponsiveStoreRegistry();
    private final TTDMockAdmin admin;
    private final TableCache<RemoteKVTable<BoundStatement>> kvFactory;
    private final TableCache<RemoteWindowedTable<BoundStatement>> windowedFactory;

    public TTDCassandraClient(TTDMockAdmin admin, Time time) {
        super(ResponsiveConfig.loggedConfig((Map)admin.props()));
        this.time = time;
        this.admin = admin;
        this.kvFactory = new TableCache(spec -> TTDKeyValueTable.create(spec, this));
        this.windowedFactory = new TableCache(spec -> TTDWindowedTable.create(spec, this));
    }

    public Time time() {
        return this.time;
    }

    public ResponsiveStoreRegistry storeRegistry() {
        return this.storeRegistry;
    }

    public TTDMockAdmin mockAdmin() {
        return this.admin;
    }

    public void advanceWallClockTime(Duration advance) {
        this.flush();
        this.time.sleep(advance.toMillis());
    }

    private void flush() {
        this.storeRegistry.stores().forEach(s -> s.onCommit().accept(0L));
    }

    public ResultSet execute(Statement<?> statement) {
        return null;
    }

    public ResultSet execute(String cql) {
        return null;
    }

    public CompletionStage<AsyncResultSet> executeAsync(Statement<?> statement) {
        throw new UnsupportedOperationException("Unexpected method call on TTD stub client");
    }

    public PreparedStatement prepare(SimpleStatement statement) {
        throw new UnsupportedOperationException("Unexpected method call on TTD stub client");
    }

    public RemoteMonitor awaitTable(String tableName) {
        return new RemoteMonitor(this.executor, () -> true);
    }

    public long count(String tableName, int tablePartition) {
        TTDKeyValueTable kv = (TTDKeyValueTable)this.kvFactory.getTable(tableName);
        TTDWindowedTable window = (TTDWindowedTable)this.windowedFactory.getTable(tableName);
        return (kv == null ? 0L : kv.count()) + (window == null ? 0L : window.count());
    }

    public OptionalInt numPartitions(String tableName) {
        return OptionalInt.of(1);
    }

    public TableCache<RemoteKVTable<BoundStatement>> kvFactory() {
        return this.kvFactory;
    }

    public TableCache<RemoteKVTable<BoundStatement>> factFactory() {
        return this.kvFactory;
    }

    public TableCache<RemoteWindowedTable<BoundStatement>> windowedFactory() {
        return this.windowedFactory;
    }
}

