/*
 * Decompiled with CFR 0.152.
 */
package dev.responsive.kafka.internal.stores;

import com.datastax.oss.driver.api.core.cql.BoundStatement;
import dev.responsive.kafka.internal.clients.TTDCassandraClient;
import dev.responsive.kafka.internal.db.CassandraClient;
import dev.responsive.kafka.internal.db.MetadataRow;
import dev.responsive.kafka.internal.db.RemoteTable;
import dev.responsive.kafka.internal.db.RemoteWriter;
import dev.responsive.kafka.internal.db.WriterFactory;
import dev.responsive.kafka.internal.db.partitioning.SubPartitioner;
import dev.responsive.kafka.internal.stores.RemoteWriteResult;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.apache.kafka.common.utils.Time;

public abstract class TTDTable<K>
implements RemoteTable<K> {
    private final TTDCassandraClient client;
    protected final Time time;

    public TTDTable(TTDCassandraClient client) {
        this.client = client;
        this.time = client.time();
    }

    public abstract long count();

    public WriterFactory<K> init(SubPartitioner partitioner, int kafkaPartition) {
        return (client, partition, batchSize) -> new TTDWriter(this, partition);
    }

    public MetadataRow metadata(int partition) {
        return new MetadataRow(0L, 0L);
    }

    public BoundStatement setOffset(int partition, long offset) {
        return null;
    }

    public CassandraClient cassandraClient() {
        return this.client;
    }

    private static class TTDWriter<K>
    implements RemoteWriter<K> {
        private final TTDTable<K> table;
        private final int partition;

        public TTDWriter(TTDTable<K> table, int partition) {
            this.table = table;
            this.partition = partition;
        }

        public void insert(K key, byte[] value, long epochMillis) {
            this.table.insert(this.partition, key, value, epochMillis);
        }

        public void delete(K key) {
            this.table.delete(this.partition, key);
        }

        public CompletionStage<RemoteWriteResult> flush() {
            return CompletableFuture.completedStage(RemoteWriteResult.success((int)this.partition));
        }

        public RemoteWriteResult setOffset(long offset) {
            this.table.setOffset(this.partition, offset);
            return RemoteWriteResult.success((int)this.partition);
        }
    }
}

