/*
 * Decompiled with CFR 0.152.
 */
package dev.responsive.kafka.api;

import dev.responsive.kafka.internal.clients.TTDCassandraClient;
import dev.responsive.kafka.internal.clients.TTDMockAdmin;
import dev.responsive.kafka.internal.config.InternalConfigs;
import dev.responsive.kafka.internal.db.CassandraClient;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.Topology;
import org.apache.kafka.streams.TopologyDescription;
import org.apache.kafka.streams.TopologyTestDriver;

public class ResponsiveTopologyTestDriver
extends TopologyTestDriver {
    public static final String RESPONSIVE_TTD_ID = "Responsive_TopologyTestDriver";
    private final TTDCassandraClient client;

    public ResponsiveTopologyTestDriver(Topology topology) {
        this(topology, new Properties());
    }

    public ResponsiveTopologyTestDriver(Topology topology, Properties config) {
        this(topology, config, null);
    }

    public ResponsiveTopologyTestDriver(Topology topology, Instant initialWallClockTimeMs) {
        this(topology, new Properties(), initialWallClockTimeMs);
    }

    public ResponsiveTopologyTestDriver(Topology topology, Properties config, Instant initialWallClockTime) {
        this(topology, config, initialWallClockTime, new TTDCassandraClient(new TTDMockAdmin(ResponsiveTopologyTestDriver.baseProps(config), topology), (Time)ResponsiveTopologyTestDriver.mockTime(initialWallClockTime)));
    }

    public void advanceWallClockTime(Duration advance) {
        this.client.advanceWallClockTime(advance);
        super.advanceWallClockTime(advance);
    }

    private ResponsiveTopologyTestDriver(Topology topology, Properties config, Instant initialWallClockTime, TTDCassandraClient cassandraClient) {
        super(topology, ResponsiveTopologyTestDriver.testDriverProps(config, topology.describe(), cassandraClient), initialWallClockTime);
        this.client = cassandraClient;
    }

    private static Properties testDriverProps(Properties userProps, TopologyDescription topologyDescription, TTDCassandraClient client) {
        Properties props = ResponsiveTopologyTestDriver.baseProps(userProps);
        props.putAll((Map<?, ?>)new InternalConfigs.Builder().withCassandraClient((CassandraClient)client).withKafkaAdmin((Admin)client.mockAdmin()).withStoreRegistry(client.storeRegistry()).withTopologyDescription(topologyDescription).build());
        return props;
    }

    private static Properties baseProps(Properties userProps) {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)userProps);
        props.put("responsive.tenant.id", RESPONSIVE_TTD_ID);
        props.put("responsive.store.flush.trigger.local.interval.ms", (Object)0);
        props.putIfAbsent("cache.max.bytes.buffering", (Object)0);
        props.putIfAbsent("application.id", RESPONSIVE_TTD_ID);
        return props;
    }

    private static MockTime mockTime(Instant initialWallClockTime) {
        MockTime mockTime = new MockTime(0L, 0L, 0L);
        long initialWallClockTimeMs = initialWallClockTime == null ? System.currentTimeMillis() : initialWallClockTime.toEpochMilli();
        mockTime.setCurrentTimeMs(initialWallClockTimeMs);
        return mockTime;
    }
}

