/*
 * Copyright 2023 Responsive Computing, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package dev.responsive.db.partitioning;

import java.util.function.Function;
import org.apache.kafka.common.utils.Bytes;

/**
 * An interface that can be implemented to customize the
 * hashing logic for {@link SubPartitioner}.
 */
public interface Hasher extends Function<Bytes, Integer> {

}
