/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.workflows.workflow;

import com.redhat.parodos.workflows.work.NoOpWork;
import com.redhat.parodos.workflows.work.Work;
import com.redhat.parodos.workflows.work.WorkContext;
import com.redhat.parodos.workflows.work.WorkReport;
import com.redhat.parodos.workflows.work.WorkReportPredicate;
import com.redhat.parodos.workflows.workflow.AbstractWorkFlow;
import java.util.UUID;

public class RepeatFlow
extends AbstractWorkFlow {
    private final Work work;
    private final WorkReportPredicate predicate;

    RepeatFlow(String name, Work work, WorkReportPredicate predicate) {
        super(name);
        this.work = work;
        this.predicate = predicate;
    }

    @Override
    public WorkReport execute(WorkContext workContext) {
        WorkReport workReport;
        while (this.predicate.apply(workReport = this.work.execute(workContext))) {
        }
        return workReport;
    }

    public static class Builder {
        private Builder() {
        }

        public static NameStep aNewRepeatFlow() {
            return new BuildSteps();
        }

        private static class BuildSteps
        implements NameStep,
        RepeatStep,
        UntilStep,
        BuildStep {
            private String name = UUID.randomUUID().toString();
            private Work work = new NoOpWork();
            private WorkReportPredicate predicate = WorkReportPredicate.ALWAYS_FALSE;

            BuildSteps() {
            }

            @Override
            public RepeatStep named(String name) {
                this.name = name;
                return this;
            }

            @Override
            public UntilStep repeat(Work work) {
                this.work = work;
                return this;
            }

            @Override
            public BuildStep until(WorkReportPredicate predicate) {
                this.predicate = predicate;
                return this;
            }

            @Override
            public BuildStep times(int times) {
                this.until(WorkReportPredicate.TimesPredicate.times(times));
                return this;
            }

            @Override
            public RepeatFlow build() {
                return new RepeatFlow(this.name, this.work, this.predicate);
            }
        }

        public static interface BuildStep {
            public RepeatFlow build();
        }

        public static interface UntilStep {
            public BuildStep until(WorkReportPredicate var1);

            public BuildStep times(int var1);
        }

        public static interface RepeatStep {
            public UntilStep repeat(Work var1);
        }

        public static interface NameStep
        extends RepeatStep {
            public RepeatStep named(String var1);
        }
    }
}

