/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.patterndetection;

import com.redhat.parodos.patterndetection.ScanningThreadPool;
import com.redhat.parodos.patterndetection.context.WorkContextDelegate;
import com.redhat.parodos.patterndetection.exceptions.PatternDetectionConfigurationException;
import com.redhat.parodos.patterndetection.pattern.Pattern;
import com.redhat.parodos.patterndetection.results.DetectionResults;
import com.redhat.parodos.workflows.work.Work;
import com.redhat.parodos.workflows.work.WorkContext;
import com.redhat.parodos.workflows.work.WorkReport;
import com.redhat.parodos.workflows.workflow.ParallelFlow;
import java.util.Date;

public class PatternDetector {
    private static final WorkContextDelegate contextDelegate = new WorkContextDelegate();

    private PatternDetector() {
    }

    public static DetectionResults detect(WorkContext context, Pattern[] desiredPatterns) {
        if (contextDelegate.validateAndIntializeContext(context)) {
            Date startTime = new Date();
            ParallelFlow workflow = ParallelFlow.Builder.aNewParallelFlow().execute((Work[])desiredPatterns).with(ScanningThreadPool.getThreadPoolExecutor()).build();
            WorkReport report = workflow.execute(context);
            contextDelegate.processResultsAfterScan(report.getWorkContext());
            return DetectionResults.builder().detectedClues(contextDelegate.getDetectedClue(report)).detectedPatterns(contextDelegate.getDetectedPatterns(report)).startTime(startTime).endTime(new Date()).build();
        }
        throw new PatternDetectionConfigurationException("The Scan for Patterns could not be started due to a misconfiguration. Please review the log files");
    }
}

