/*
 * Decompiled with CFR 0.152.
 */
package dev.learning.xapi.samples.poststatement;

import dev.learning.xapi.client.XapiClient;
import dev.learning.xapi.model.Agent;
import dev.learning.xapi.model.Verb;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.util.Locale;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.http.ResponseEntity;

@SpringBootApplication
public class PostSignedStatementApplication
implements CommandLineRunner {
    @Autowired
    private XapiClient client;

    public static void main(String[] args) {
        SpringApplication.run(PostSignedStatementApplication.class, (String[])args).close();
    }

    public void run(String ... args) throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(2048);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        ResponseEntity response = (ResponseEntity)this.client.postStatement(r -> r.signedStatement(s -> s.agentActor(a -> ((Agent.Builder)a.name("A N Other")).mbox("mailto:another@example.com")).verb(Verb.ATTEMPTED).activityObject(o -> o.id("https://example.com/activity/simplestatement").definition(d -> d.addName(Locale.ENGLISH, "Simple Statement"))), keyPair.getPrivate())).block();
        System.out.println("StatementId " + response.getBody());
    }
}

