/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.watsonx;

import com.ibm.watsonx.ai.CloudRegion;
import com.ibm.watsonx.ai.core.auth.AuthenticationProvider;
import com.ibm.watsonx.ai.core.auth.iam.IAMAuthenticator;
import com.ibm.watsonx.ai.embedding.EmbeddingParameters;
import com.ibm.watsonx.ai.embedding.EmbeddingResponse;
import com.ibm.watsonx.ai.embedding.EmbeddingService;
import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.watsonx.WatsonxBuilder;
import dev.langchain4j.model.watsonx.WatsonxExceptionMapper;
import java.time.Duration;
import java.util.List;
import java.util.Objects;

public class WatsonxEmbeddingModel
implements EmbeddingModel {
    private final EmbeddingService embeddingService;

    private WatsonxEmbeddingModel(Builder builder) {
        EmbeddingService.Builder embeddingServiceBuilder = EmbeddingService.builder();
        if (Objects.nonNull(builder.authenticationProvider)) {
            embeddingServiceBuilder.authenticationProvider(builder.authenticationProvider);
        } else {
            embeddingServiceBuilder.authenticationProvider((AuthenticationProvider)IAMAuthenticator.builder().apiKey(builder.apiKey).build());
        }
        this.embeddingService = ((EmbeddingService.Builder)((EmbeddingService.Builder)((EmbeddingService.Builder)((EmbeddingService.Builder)((EmbeddingService.Builder)((EmbeddingService.Builder)((EmbeddingService.Builder)((EmbeddingService.Builder)embeddingServiceBuilder.baseUrl(builder.url)).modelId(builder.modelName)).version(builder.version)).projectId(builder.projectId)).spaceId(builder.spaceId)).timeout(builder.timeout)).logRequests(builder.logRequests)).logResponses(builder.logResponses)).build();
    }

    public Response<List<Embedding>> embedAll(List<TextSegment> textSegments) {
        return this.embedAll(textSegments, null);
    }

    public Response<List<Embedding>> embedAll(List<TextSegment> textSegments, EmbeddingParameters parameters) {
        if (Objects.isNull(textSegments) || textSegments.isEmpty()) {
            return Response.from(List.of());
        }
        List<String> inputs = textSegments.stream().map(TextSegment::text).toList();
        EmbeddingResponse response = (EmbeddingResponse)WatsonxExceptionMapper.INSTANCE.withExceptionMapper(() -> this.embeddingService.embedding(inputs, parameters));
        return Response.from(response.results().stream().map(EmbeddingResponse.Result::embedding).map(Embedding::from).toList());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends WatsonxBuilder<Builder> {
        private String modelName;
        private String projectId;
        private String spaceId;
        private Duration timeout;

        private Builder() {
        }

        public Builder url(CloudRegion cloudRegion) {
            return (Builder)super.url(cloudRegion.getMlEndpoint());
        }

        public Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder spaceId(String spaceId) {
            this.spaceId = spaceId;
            return this;
        }

        public Builder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public WatsonxEmbeddingModel build() {
            return new WatsonxEmbeddingModel(this);
        }
    }
}

