/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.ovhai;

import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.internal.RetryUtils;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.ovhai.internal.api.EmbeddingRequest;
import dev.langchain4j.model.ovhai.internal.api.EmbeddingResponse;
import dev.langchain4j.model.ovhai.internal.client.DefaultOvhAiClient;
import java.time.Duration;
import java.util.List;
import java.util.stream.Collectors;

public class OvhAiEmbeddingModel
implements EmbeddingModel {
    private final DefaultOvhAiClient client;
    private final int maxRetries;

    private OvhAiEmbeddingModel(String baseUrl, String apiKey, Duration timeout, Integer maxRetries, Boolean logRequests, Boolean logResponses) {
        this.client = ((DefaultOvhAiClient.Builder)((DefaultOvhAiClient.Builder)((DefaultOvhAiClient.Builder)((DefaultOvhAiClient.Builder)((DefaultOvhAiClient.Builder)DefaultOvhAiClient.builder().baseUrl(baseUrl)).apiKey(apiKey)).timeout((Duration)Utils.getOrDefault((Object)timeout, (Object)Duration.ofSeconds(60L)))).logRequests((Boolean)Utils.getOrDefault((Object)logRequests, (Object)false))).logResponses((Boolean)Utils.getOrDefault((Object)logResponses, (Object)false))).build();
        this.maxRetries = (Integer)Utils.getOrDefault((Object)maxRetries, (Object)2);
    }

    @Deprecated(forRemoval=true)
    public static OvhAiEmbeddingModel withApiKey(String apiKey) {
        return OvhAiEmbeddingModel.builder().apiKey(apiKey).build();
    }

    public static OvhAiEmbeddingModelBuilder builder() {
        return new OvhAiEmbeddingModelBuilder();
    }

    public Response<List<Embedding>> embedAll(List<TextSegment> textSegments) {
        EmbeddingRequest request = EmbeddingRequest.builder().input(textSegments.stream().map(TextSegment::text).collect(Collectors.toList())).build();
        EmbeddingResponse response = (EmbeddingResponse)RetryUtils.withRetryMappingExceptions(() -> this.client.embed(request), (int)this.maxRetries);
        List embeddings = response.getEmbeddings().stream().map(Embedding::from).collect(Collectors.toList());
        return Response.from(embeddings);
    }

    public static class OvhAiEmbeddingModelBuilder {
        private String baseUrl;
        private String apiKey;
        private Duration timeout;
        private Integer maxRetries;
        private Boolean logRequests;
        private Boolean logResponses;

        OvhAiEmbeddingModelBuilder() {
        }

        public OvhAiEmbeddingModelBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public OvhAiEmbeddingModelBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public OvhAiEmbeddingModelBuilder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public OvhAiEmbeddingModelBuilder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public OvhAiEmbeddingModelBuilder logRequests(Boolean logRequests) {
            this.logRequests = logRequests;
            return this;
        }

        public OvhAiEmbeddingModelBuilder logResponses(Boolean logResponses) {
            this.logResponses = logResponses;
            return this;
        }

        public OvhAiEmbeddingModel build() {
            return new OvhAiEmbeddingModel(this.baseUrl, this.apiKey, this.timeout, this.maxRetries, this.logRequests, this.logResponses);
        }

        public String toString() {
            return "OvhAiEmbeddingModel.OvhAiEmbeddingModelBuilder(baseUrl=" + this.baseUrl + ", apiKey=" + this.apiKey + ", timeout=" + String.valueOf(this.timeout) + ", maxRetries=" + this.maxRetries + ", logRequests=" + this.logRequests + ", logResponses=" + this.logResponses + ")";
        }
    }
}

