package dev.langchain4j.mistralai.spring;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

import lombok.Getter;
import lombok.Setter;

@Getter
@Setter
@ConfigurationProperties(prefix = Properties.PREFIX)
public class Properties {

    public static final String PREFIX = "langchain4j.mistral-ai";

    @NestedConfigurationProperty
    ChatModelProperties chatModel;

    @NestedConfigurationProperty
    ChatModelProperties streamingChatModel;

    @NestedConfigurationProperty
    EmbeddingModelProperties embeddingModel;

    @NestedConfigurationProperty
    FimModelProperties fimModel;

    @NestedConfigurationProperty
    FimModelProperties streamingFimModel;

    @NestedConfigurationProperty
    ModerationModelProperties moderationModel;
}
