/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.mistralai.spring;

import dev.langchain4j.http.client.HttpClientBuilder;
import dev.langchain4j.http.client.spring.restclient.SpringRestClient;
import dev.langchain4j.mistralai.spring.ChatModelProperties;
import dev.langchain4j.mistralai.spring.EmbeddingModelProperties;
import dev.langchain4j.mistralai.spring.FimModelProperties;
import dev.langchain4j.mistralai.spring.ModerationModelProperties;
import dev.langchain4j.mistralai.spring.Properties;
import dev.langchain4j.model.chat.listener.ChatModelListener;
import dev.langchain4j.model.mistralai.MistralAiChatModel;
import dev.langchain4j.model.mistralai.MistralAiEmbeddingModel;
import dev.langchain4j.model.mistralai.MistralAiFimModel;
import dev.langchain4j.model.mistralai.MistralAiModerationModel;
import dev.langchain4j.model.mistralai.MistralAiStreamingChatModel;
import dev.langchain4j.model.mistralai.MistralAiStreamingFimModel;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.core.task.TaskDecorator;
import org.springframework.core.task.support.ContextPropagatingTaskDecorator;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.web.client.RestClient;

@AutoConfiguration
@EnableConfigurationProperties(value={Properties.class})
public class AutoConfig {
    private static final String TASK_EXECUTOR_THREAD_NAME_PREFIX = "LangChain4j-MistralAI-";
    private static final String CHAT_MODEL_HTTP_CLIENT_BUILDER = "mistralAiChatModelHttpClientBuilder";
    private static final String STREAMING_CHAT_MODEL_HTTP_CLIENT_BUILDER = "mistralAiStreamingChatModelHttpClientBuilder";
    private static final String STREAMING_CHAT_MODEL_TASK_EXECUTOR = "mistralAiStreamingChatModelTaskExecutor";
    private static final String FIM_MODEL_HTTP_CLIENT_BUILDER = "mistralAiFimModelHttpClientBuilder";
    private static final String STREAMING_FIM_MODEL_HTTP_CLIENT_BUILDER = "mistralAiStreamingFimModelHttpClientBuilder";
    private static final String STREAMING_FIM_MODEL_TASK_EXECUTOR = "mistralAiStreamingFimModelTaskExecutor";
    private static final String EMBEDDING_MODEL_HTTP_CLIENT_BUILDER = "mistralAiEmbeddingModelHttpClientBuilder";
    private static final String MODERATION_MODEL_HTTP_CLIENT_BUILDER = "mistralAiModerationModelHttpClientBuilder";

    @Bean
    @ConditionalOnProperty(value={"langchain4j.mistral-ai.chat-model.api-key"})
    MistralAiChatModel mistralAiChatModel(@Qualifier(value="mistralAiChatModelHttpClientBuilder") HttpClientBuilder httpClientBuilder, Properties properties, ObjectProvider<ChatModelListener> listeners) {
        ChatModelProperties chatModelProperties = properties.getChatModel();
        MistralAiChatModel.MistralAiChatModelBuilder builder = MistralAiChatModel.builder().httpClientBuilder(httpClientBuilder).baseUrl(chatModelProperties.getBaseUrl()).apiKey(chatModelProperties.getApiKey()).modelName(chatModelProperties.getModelName()).temperature(chatModelProperties.getTemperature()).topP(chatModelProperties.getTopP()).maxTokens(chatModelProperties.getMaxTokens()).safePrompt(chatModelProperties.getSafePrompt()).randomSeed(chatModelProperties.getRandomSeed()).responseFormat(chatModelProperties.getResponseFormat()).stopSequences(chatModelProperties.getStopSequences()).frequencyPenalty(chatModelProperties.getFrequencyPenalty()).presencePenalty(chatModelProperties.getPresencePenalty()).timeout(chatModelProperties.getTimeout()).logRequests(chatModelProperties.getLogRequests()).logResponses(chatModelProperties.getLogResponses()).listeners(listeners.orderedStream().toList());
        if (chatModelProperties.getMaxRetries() != null) {
            builder.maxRetries(chatModelProperties.getMaxRetries());
        }
        if (chatModelProperties.getSupportedCapabilities() != null) {
            builder.supportedCapabilities(chatModelProperties.getSupportedCapabilities());
        }
        return builder.build();
    }

    @Bean(value={"mistralAiChatModelHttpClientBuilder"})
    @ConditionalOnProperty(value={"langchain4j.mistral-ai.chat-model.api-key"})
    @ConditionalOnMissingBean(name={"mistralAiChatModelHttpClientBuilder"})
    HttpClientBuilder mistralAiChatModelHttpClientBuilder(ObjectProvider<RestClient.Builder> restClientBuilder) {
        return SpringRestClient.builder().restClientBuilder((RestClient.Builder)restClientBuilder.getIfAvailable(RestClient::builder)).createDefaultStreamingRequestExecutor(Boolean.valueOf(false));
    }

    @Bean
    @ConditionalOnProperty(value={"langchain4j.mistral-ai.streaming-chat-model.api-key"})
    MistralAiStreamingChatModel mistralAiStreamingChatModel(@Qualifier(value="mistralAiStreamingChatModelHttpClientBuilder") HttpClientBuilder httpClientBuilder, Properties properties, ObjectProvider<ChatModelListener> listeners) {
        ChatModelProperties chatModelProperties = properties.getStreamingChatModel();
        MistralAiStreamingChatModel.MistralAiStreamingChatModelBuilder builder = MistralAiStreamingChatModel.builder().httpClientBuilder(httpClientBuilder).baseUrl(chatModelProperties.getBaseUrl()).apiKey(chatModelProperties.getApiKey()).modelName(chatModelProperties.getModelName()).temperature(chatModelProperties.getTemperature()).topP(chatModelProperties.getTopP()).maxTokens(chatModelProperties.getMaxTokens()).safePrompt(chatModelProperties.getSafePrompt()).randomSeed(chatModelProperties.getRandomSeed()).responseFormat(chatModelProperties.getResponseFormat()).stopSequences(chatModelProperties.getStopSequences()).frequencyPenalty(chatModelProperties.getFrequencyPenalty()).presencePenalty(chatModelProperties.getPresencePenalty()).timeout(chatModelProperties.getTimeout()).logRequests(chatModelProperties.getLogRequests()).logResponses(chatModelProperties.getLogResponses()).listeners(listeners.orderedStream().toList());
        if (chatModelProperties.getSupportedCapabilities() != null) {
            builder.supportedCapabilities(chatModelProperties.getSupportedCapabilities());
        }
        return builder.build();
    }

    @Bean(value={"mistralAiStreamingChatModelHttpClientBuilder"})
    @ConditionalOnProperty(value={"langchain4j.mistral-ai.streaming-chat-model.api-key"})
    @ConditionalOnMissingBean(name={"mistralAiStreamingChatModelHttpClientBuilder"})
    HttpClientBuilder mistralAiStreamingChatModelHttpClientBuilder(ObjectProvider<RestClient.Builder> restClientBuilder, @Qualifier(value="mistralAiStreamingChatModelTaskExecutor") AsyncTaskExecutor executor) {
        return SpringRestClient.builder().restClientBuilder((RestClient.Builder)restClientBuilder.getIfAvailable(RestClient::builder)).streamingRequestExecutor(executor);
    }

    @Bean(value={"mistralAiStreamingChatModelTaskExecutor"})
    @ConditionalOnProperty(value={"langchain4j.mistral-ai.streaming-chat-model.api-key"})
    @ConditionalOnMissingBean(name={"mistralAiStreamingChatModelTaskExecutor"})
    @ConditionalOnClass(name={"io.micrometer.context.ContextSnapshotFactory"})
    AsyncTaskExecutor mistralAiStreamingChatModelTaskExecutorWithContextPropagation() {
        ThreadPoolTaskExecutor taskExecutor = new ThreadPoolTaskExecutor();
        taskExecutor.setQueueCapacity(0);
        taskExecutor.setThreadNamePrefix(TASK_EXECUTOR_THREAD_NAME_PREFIX);
        taskExecutor.setTaskDecorator((TaskDecorator)new ContextPropagatingTaskDecorator());
        return taskExecutor;
    }

    @Bean(value={"mistralAiStreamingChatModelTaskExecutor"})
    @ConditionalOnProperty(value={"langchain4j.mistral-ai.streaming-chat-model.api-key"})
    @ConditionalOnMissingBean(name={"mistralAiStreamingChatModelTaskExecutor"})
    @ConditionalOnMissingClass(value={"io.micrometer.context.ContextSnapshotFactory"})
    AsyncTaskExecutor mistralAiStreamingChatModelTaskExecutor() {
        ThreadPoolTaskExecutor taskExecutor = new ThreadPoolTaskExecutor();
        taskExecutor.setQueueCapacity(0);
        taskExecutor.setThreadNamePrefix(TASK_EXECUTOR_THREAD_NAME_PREFIX);
        return taskExecutor;
    }

    @Bean
    @ConditionalOnProperty(value={"langchain4j.mistral-ai.embedding-model.api-key"})
    MistralAiEmbeddingModel mistralAiEmbeddingModel(@Qualifier(value="mistralAiEmbeddingModelHttpClientBuilder") HttpClientBuilder httpClientBuilder, Properties properties) {
        EmbeddingModelProperties embeddingModelProperties = properties.getEmbeddingModel();
        return MistralAiEmbeddingModel.builder().httpClientBuilder(httpClientBuilder).baseUrl(embeddingModelProperties.getBaseUrl()).apiKey(embeddingModelProperties.getApiKey()).modelName(embeddingModelProperties.getModelName()).timeout(embeddingModelProperties.getTimeout()).logRequests(embeddingModelProperties.getLogRequests()).logResponses(embeddingModelProperties.getLogResponses()).maxRetries(embeddingModelProperties.getMaxRetries()).build();
    }

    @Bean(value={"mistralAiEmbeddingModelHttpClientBuilder"})
    @ConditionalOnProperty(value={"langchain4j.mistral-ai.embedding-model.api-key"})
    @ConditionalOnMissingBean(name={"mistralAiEmbeddingModelHttpClientBuilder"})
    HttpClientBuilder mistralAiEmbeddingModelHttpClientBuilder(ObjectProvider<RestClient.Builder> restClientBuilder) {
        return SpringRestClient.builder().restClientBuilder((RestClient.Builder)restClientBuilder.getIfAvailable(RestClient::builder)).createDefaultStreamingRequestExecutor(Boolean.valueOf(false));
    }

    @Bean
    @ConditionalOnProperty(value={"langchain4j.mistral-ai.fim-model.api-key"})
    MistralAiFimModel mistralAiFimModel(@Qualifier(value="mistralAiFimModelHttpClientBuilder") HttpClientBuilder httpClientBuilder, Properties properties) {
        FimModelProperties fimModelProperties = properties.getFimModel();
        return MistralAiFimModel.builder().httpClientBuilder(httpClientBuilder).baseUrl(fimModelProperties.getBaseUrl()).apiKey(fimModelProperties.getApiKey()).modelName(fimModelProperties.getModelName()).temperature(fimModelProperties.getTemperature()).maxTokens(fimModelProperties.getMaxTokens()).minTokens(fimModelProperties.getMinTokens()).topP(fimModelProperties.getTopP()).randomSeed(fimModelProperties.getRandomSeed()).stop(fimModelProperties.getStop()).timeout(fimModelProperties.getTimeout()).logRequests(fimModelProperties.getLogRequests()).logResponses(fimModelProperties.getLogResponses()).maxRetries(fimModelProperties.getMaxRetries()).build();
    }

    @Bean(value={"mistralAiFimModelHttpClientBuilder"})
    @ConditionalOnProperty(value={"langchain4j.mistral-ai.fim-model.api-key"})
    @ConditionalOnMissingBean(name={"mistralAiFimModelHttpClientBuilder"})
    HttpClientBuilder mistralAiFimModelHttpClientBuilder(ObjectProvider<RestClient.Builder> restClientBuilder) {
        return SpringRestClient.builder().restClientBuilder((RestClient.Builder)restClientBuilder.getIfAvailable(RestClient::builder)).createDefaultStreamingRequestExecutor(Boolean.valueOf(false));
    }

    @Bean
    @ConditionalOnProperty(value={"langchain4j.mistral-ai.streaming-fim-model.api-key"})
    MistralAiStreamingFimModel mistralAiStreamingFimModel(@Qualifier(value="mistralAiStreamingFimModelHttpClientBuilder") HttpClientBuilder httpClientBuilder, Properties properties) {
        FimModelProperties fimModelProperties = properties.getStreamingFimModel();
        return MistralAiStreamingFimModel.builder().httpClientBuilder(httpClientBuilder).baseUrl(fimModelProperties.getBaseUrl()).apiKey(fimModelProperties.getApiKey()).modelName(fimModelProperties.getModelName()).temperature(fimModelProperties.getTemperature()).maxTokens(fimModelProperties.getMaxTokens()).minTokens(fimModelProperties.getMinTokens()).topP(fimModelProperties.getTopP()).randomSeed(fimModelProperties.getRandomSeed()).stop(fimModelProperties.getStop()).timeout(fimModelProperties.getTimeout()).logRequests(fimModelProperties.getLogRequests()).logResponses(fimModelProperties.getLogResponses()).build();
    }

    @Bean(value={"mistralAiStreamingFimModelHttpClientBuilder"})
    @ConditionalOnProperty(value={"langchain4j.mistral-ai.streaming-fim-model.api-key"})
    @ConditionalOnMissingBean(name={"mistralAiStreamingFimModelHttpClientBuilder"})
    HttpClientBuilder mistralAiStreamingFimModelHttpClientBuilder(ObjectProvider<RestClient.Builder> restClientBuilder, @Qualifier(value="mistralAiStreamingFimModelTaskExecutor") AsyncTaskExecutor executor) {
        return SpringRestClient.builder().restClientBuilder((RestClient.Builder)restClientBuilder.getIfAvailable(RestClient::builder)).streamingRequestExecutor(executor);
    }

    @Bean(value={"mistralAiStreamingFimModelTaskExecutor"})
    @ConditionalOnProperty(value={"langchain4j.mistral-ai.streaming-fim-model.api-key"})
    @ConditionalOnMissingBean(name={"mistralAiStreamingFimModelTaskExecutor"})
    @ConditionalOnClass(name={"io.micrometer.context.ContextSnapshotFactory"})
    AsyncTaskExecutor mistralAiStreamingFimModelTaskExecutorWithContextPropagation() {
        ThreadPoolTaskExecutor taskExecutor = new ThreadPoolTaskExecutor();
        taskExecutor.setQueueCapacity(0);
        taskExecutor.setThreadNamePrefix(TASK_EXECUTOR_THREAD_NAME_PREFIX);
        taskExecutor.setTaskDecorator((TaskDecorator)new ContextPropagatingTaskDecorator());
        return taskExecutor;
    }

    @Bean(value={"mistralAiStreamingFimModelTaskExecutor"})
    @ConditionalOnProperty(value={"langchain4j.mistral-ai.streaming-fim-model.api-key"})
    @ConditionalOnMissingBean(name={"mistralAiStreamingFimModelTaskExecutor"})
    @ConditionalOnMissingClass(value={"io.micrometer.context.ContextSnapshotFactory"})
    AsyncTaskExecutor mistralAiStreamingFimModelTaskExecutor() {
        ThreadPoolTaskExecutor taskExecutor = new ThreadPoolTaskExecutor();
        taskExecutor.setQueueCapacity(0);
        taskExecutor.setThreadNamePrefix(TASK_EXECUTOR_THREAD_NAME_PREFIX);
        return taskExecutor;
    }

    @Bean
    @ConditionalOnProperty(value={"langchain4j.mistral-ai.moderation-model.api-key"})
    MistralAiModerationModel mistralAiModerationModel(@Qualifier(value="mistralAiModerationModelHttpClientBuilder") HttpClientBuilder httpClientBuilder, Properties properties) {
        ModerationModelProperties moderationModelProperties = properties.getModerationModel();
        MistralAiModerationModel.Builder builder = new MistralAiModerationModel.Builder().httpClientBuilder(httpClientBuilder).baseUrl(moderationModelProperties.getBaseUrl()).apiKey(moderationModelProperties.getApiKey()).modelName(moderationModelProperties.getModelName()).timeout(moderationModelProperties.getTimeout()).logRequests(moderationModelProperties.getLogRequests()).logResponses(moderationModelProperties.getLogResponses());
        if (moderationModelProperties.getMaxRetries() != null) {
            builder.maxRetries(moderationModelProperties.getMaxRetries().intValue());
        }
        return builder.build();
    }

    @Bean(value={"mistralAiModerationModelHttpClientBuilder"})
    @ConditionalOnProperty(value={"langchain4j.mistral-ai.moderation-model.api-key"})
    @ConditionalOnMissingBean(name={"mistralAiModerationModelHttpClientBuilder"})
    HttpClientBuilder mistralAiModerationModelHttpClientBuilder(ObjectProvider<RestClient.Builder> restClientBuilder) {
        return SpringRestClient.builder().restClientBuilder((RestClient.Builder)restClientBuilder.getIfAvailable(RestClient::builder)).createDefaultStreamingRequestExecutor(Boolean.valueOf(false));
    }
}

