package dev.langchain4j.kotlin.data.document

import dev.langchain4j.data.document.Document
import dev.langchain4j.data.document.DocumentLoader
import dev.langchain4j.data.document.DocumentParser
import dev.langchain4j.data.document.DocumentSource
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.withContext
import kotlin.coroutines.CoroutineContext

/**
 * Asynchronously loads a document from the specified source using a given parser.
 *
 * @param source The [dev.langchain4j.data.document.DocumentSource] from which the document will be loaded.
 * @param parser The [dev.langchain4j.data.document.DocumentParser] to parse the loaded document.
 * @param context The [CoroutineContext] to use for asynchronous execution,
 *                  defaults to `Dispatchers.IO`.
 * @return The loaded and parsed Document.
 */
public suspend fun loadAsync(
    source: DocumentSource,
    parser: DocumentParser,
    context: CoroutineContext = Dispatchers.IO
): Document =
    withContext(context) {
        DocumentLoader.load(source, parser)
    }
