/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.http.client;

import dev.langchain4j.http.client.HttpMethod;
import dev.langchain4j.http.client.HttpRequest;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AssertionsForClassTypes;
import org.assertj.core.api.MapAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class HttpRequestTest {
    HttpRequestTest() {
    }

    @ParameterizedTest
    @MethodSource(value={"validUrlCombinations"})
    void should_correctly_concatenate_baseUrl_and_path(String baseUrl, String path, String expectedUrl) {
        String result = HttpRequest.builder().method(HttpMethod.GET).url(baseUrl, path).build().url();
        Assertions.assertThat((String)result).isEqualTo(expectedUrl);
    }

    private static Stream<Arguments> validUrlCombinations() {
        return Stream.of(Arguments.of((Object[])new Object[]{"http://example.com", "/api", "http://example.com/api"}), Arguments.of((Object[])new Object[]{"http://example.com/", "/api", "http://example.com/api"}), Arguments.of((Object[])new Object[]{"http://example.com", "api", "http://example.com/api"}), Arguments.of((Object[])new Object[]{"http://example.com/", "api", "http://example.com/api"}), Arguments.of((Object[])new Object[]{"http://example.com/v1", "/api", "http://example.com/v1/api"}), Arguments.of((Object[])new Object[]{"http://example.com/v1/", "/api", "http://example.com/v1/api"}));
    }

    @Test
    void should_throw_exception_when_baseUrl_is_null_or_blank() {
        ((AbstractThrowableAssert)AssertionsForClassTypes.assertThatThrownBy(() -> HttpRequest.builder().url(null, "/api")).isInstanceOf(IllegalArgumentException.class)).hasMessage("baseUrl cannot be null or blank");
        ((AbstractThrowableAssert)AssertionsForClassTypes.assertThatThrownBy(() -> HttpRequest.builder().url("", "/api")).isInstanceOf(IllegalArgumentException.class)).hasMessage("baseUrl cannot be null or blank");
        ((AbstractThrowableAssert)AssertionsForClassTypes.assertThatThrownBy(() -> HttpRequest.builder().url(" ", "/api")).isInstanceOf(IllegalArgumentException.class)).hasMessage("baseUrl cannot be null or blank");
    }

    @Test
    void should_throw_exception_when_path_is_null_or_blank() {
        ((AbstractThrowableAssert)AssertionsForClassTypes.assertThatThrownBy(() -> HttpRequest.builder().url("http://example.com", null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("path cannot be null or blank");
        ((AbstractThrowableAssert)AssertionsForClassTypes.assertThatThrownBy(() -> HttpRequest.builder().url("http://example.com", "")).isInstanceOf(IllegalArgumentException.class)).hasMessage("path cannot be null or blank");
        ((AbstractThrowableAssert)AssertionsForClassTypes.assertThatThrownBy(() -> HttpRequest.builder().url("http://example.com", " ")).isInstanceOf(IllegalArgumentException.class)).hasMessage("path cannot be null or blank");
    }

    @Test
    void should_add_single_header() {
        HttpRequest.Builder builder = HttpRequest.builder().method(HttpMethod.GET).url("http://example.com");
        builder.addHeader("Content-Type", new String[]{"application/json"});
        Assertions.assertThat((Map)builder.build().headers()).containsEntry((Object)"Content-Type", List.of("application/json"));
    }

    @Test
    void should_add_multiple_values_for_single_header() {
        HttpRequest.Builder builder = HttpRequest.builder().method(HttpMethod.GET).url("http://example.com");
        builder.addHeader("Accept", new String[]{"application/json", "application/xml"});
        Assertions.assertThat((Map)builder.build().headers()).containsEntry((Object)"Accept", List.of("application/json", "application/xml"));
    }

    @Test
    void should_throw_exception_when_header_name_is_null_or_blank() {
        HttpRequest.Builder builder = HttpRequest.builder().method(HttpMethod.GET).url("http://example.com");
        ((AbstractThrowableAssert)AssertionsForClassTypes.assertThatThrownBy(() -> builder.addHeader(null, new String[]{"value"})).isInstanceOf(IllegalArgumentException.class)).hasMessage("name cannot be null or blank");
        ((AbstractThrowableAssert)AssertionsForClassTypes.assertThatThrownBy(() -> builder.addHeader("", new String[]{"value"})).isInstanceOf(IllegalArgumentException.class)).hasMessage("name cannot be null or blank");
        ((AbstractThrowableAssert)AssertionsForClassTypes.assertThatThrownBy(() -> builder.addHeader(" ", new String[]{"value"})).isInstanceOf(IllegalArgumentException.class)).hasMessage("name cannot be null or blank");
    }

    @Test
    void should_add_headers_from_map() {
        HttpRequest.Builder builder = HttpRequest.builder().method(HttpMethod.GET).url("http://example.com");
        Map<String, String> headers = Map.of("Content-Type", "application/json", "Accept", "text/plain");
        builder.addHeaders(headers);
        ((MapAssert)Assertions.assertThat((Map)builder.build().headers()).containsEntry((Object)"Content-Type", List.of("application/json"))).containsEntry((Object)"Accept", List.of("text/plain"));
    }

    @Test
    void should_handle_null_headers_map() {
        HttpRequest.Builder builder = HttpRequest.builder().method(HttpMethod.GET).url("http://example.com");
        HttpRequest.Builder result = builder.addHeaders(null);
        Assertions.assertThat((Object)result).isSameAs((Object)builder);
        Assertions.assertThat((Map)builder.build().headers()).isEmpty();
    }

    @Test
    void should_handle_empty_headers_map() {
        HttpRequest.Builder builder = HttpRequest.builder().method(HttpMethod.GET).url("http://example.com");
        HttpRequest.Builder result = builder.addHeaders(Map.of());
        Assertions.assertThat((Object)result).isSameAs((Object)builder);
        Assertions.assertThat((Map)builder.build().headers()).isEmpty();
    }

    @ParameterizedTest
    @MethodSource(value={"headerCombinations"})
    void shouldCombineHeadersFromBothMethods(String singleHeaderName, String[] singleHeaderValues, Map<String, String> mapHeaders, Map<String, List<String>> expectedHeaders) {
        HttpRequest.Builder builder = HttpRequest.builder().method(HttpMethod.GET).url("http://example.com");
        builder.addHeader(singleHeaderName, singleHeaderValues).addHeaders(mapHeaders);
        Assertions.assertThat((Map)builder.build().headers()).containsExactlyInAnyOrderEntriesOf(expectedHeaders);
    }

    private static Stream<Arguments> headerCombinations() {
        return Stream.of(Arguments.of((Object[])new Object[]{"Content-Type", new String[]{"application/json"}, Map.of("Accept", "text/plain"), Map.of("Content-Type", List.of("application/json"), "Accept", List.of("text/plain"))}), Arguments.of((Object[])new Object[]{"Accept", new String[]{"application/json", "application/xml"}, Map.of("Content-Type", "application/json"), Map.of("Accept", List.of("application/json", "application/xml"), "Content-Type", List.of("application/json"))}), Arguments.of((Object[])new Object[]{"X-Custom-Header", new String[]{"value1"}, Map.of("X-Custom-Header", "value2", "Accept", "application/json"), Map.of("X-Custom-Header", List.of("value2"), "Accept", List.of("application/json"))}));
    }

    @Test
    void should_overwrite_headers_when_added_multiple_times() {
        HttpRequest.Builder builder = HttpRequest.builder().method(HttpMethod.GET).url("http://example.com");
        builder.addHeader("Accept", new String[]{"application/json"}).addHeaders(Map.of("Accept", "text/plain"));
        Assertions.assertThat((Map)builder.build().headers()).containsEntry((Object)"Accept", List.of("text/plain"));
    }

    @Test
    void should_build_request_with_all_components() {
        HttpRequest request = HttpRequest.builder().method(HttpMethod.POST).url("https://api.example.com/v1/users").addHeader("Content-Type", new String[]{"application/json"}).body("request body content").build();
        Assertions.assertThat((Comparable)request.method()).isEqualTo((Object)HttpMethod.POST);
        Assertions.assertThat((String)request.url()).isEqualTo("https://api.example.com/v1/users");
        Assertions.assertThat((Map)request.headers()).containsEntry((Object)"Content-Type", List.of("application/json"));
        Assertions.assertThat((String)request.body()).isEqualTo("request body content");
    }

    @Test
    void should_handle_urls_with_query_parameters() {
        String result = HttpRequest.builder().method(HttpMethod.GET).url("https://api.example.com", "/search?q=test&limit=5").build().url();
        Assertions.assertThat((String)result).isEqualTo("https://api.example.com/search?q=test&limit=5");
    }

    @Test
    void should_handle_null_body() {
        HttpRequest request = HttpRequest.builder().method(HttpMethod.GET).url("http://example.com").body(null).build();
        Assertions.assertThat((String)request.body()).isNull();
    }

    @Test
    void should_throw_exception_when_method_is_null() {
        AssertionsForClassTypes.assertThatThrownBy(() -> HttpRequest.builder().method(null).url("http://example.com").build()).isInstanceOf(IllegalArgumentException.class);
    }
}

