/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.http.client;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import dev.langchain4j.exception.TimeoutException;
import dev.langchain4j.http.client.HttpClient;
import dev.langchain4j.http.client.HttpMethod;
import dev.langchain4j.http.client.HttpRequest;
import dev.langchain4j.http.client.SuccessfulHttpResponse;
import dev.langchain4j.http.client.sse.DefaultServerSentEventParser;
import dev.langchain4j.http.client.sse.ServerSentEvent;
import dev.langchain4j.http.client.sse.ServerSentEventListener;
import dev.langchain4j.http.client.sse.ServerSentEventParser;
import java.time.Duration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public abstract class HttpClientTimeoutIT {
    private static final int WIREMOCK_PORT = 8083;
    private WireMockServer wireMockServer;

    protected abstract List<HttpClient> clients(Duration var1);

    protected abstract Class<? extends Exception> expectedReadTimeoutRootCauseExceptionType();

    @BeforeEach
    void beforeEach() {
        this.wireMockServer = new WireMockServer((Options)WireMockConfiguration.options().port(8083));
        this.wireMockServer.start();
        WireMock.configureFor((String)"localhost", (int)8083);
    }

    @AfterEach
    void afterEach() {
        if (this.wireMockServer != null) {
            this.wireMockServer.stop();
        }
    }

    @Test
    void should_timeout_on_read_sync() {
        int readTimeoutMillis = 250;
        for (HttpClient client : this.clients(Duration.ofMillis(readTimeoutMillis))) {
            this.wireMockServer.stubFor(WireMock.get((String)"/endpoint").willReturn(WireMock.aResponse().withFixedDelay(Integer.valueOf(readTimeoutMillis * 2))));
            HttpRequest request = HttpRequest.builder().method(HttpMethod.GET).url(String.format("http://localhost:%s/endpoint", 8083)).build();
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> client.execute(request)).isExactlyInstanceOf(TimeoutException.class)).hasRootCauseExactlyInstanceOf(this.expectedReadTimeoutRootCauseExceptionType()).hasMessageContainingAll(new CharSequence[]{"time", "out"});
        }
    }

    @Test
    void should_timeout_on_read_async() throws Exception {
        int readTimeoutMillis = 250;
        for (HttpClient client : this.clients(Duration.ofMillis(readTimeoutMillis))) {
            this.wireMockServer.stubFor(WireMock.get((String)"/endpoint").willReturn(WireMock.aResponse().withFixedDelay(Integer.valueOf(readTimeoutMillis * 2))));
            HttpRequest request = HttpRequest.builder().method(HttpMethod.GET).url(String.format("http://localhost:%s/endpoint", 8083)).build();
            final CompletableFuture completableFuture = new CompletableFuture();
            ServerSentEventListener listener = new ServerSentEventListener(){
                private final Set<Thread> threads = new HashSet<Thread>();
                final /* synthetic */ HttpClientTimeoutIT this$0;
                {
                    this.this$0 = this$0;
                }

                public void onOpen(SuccessfulHttpResponse successfulHttpResponse) {
                    completableFuture.completeExceptionally(new IllegalStateException("onOpen() should not be called"));
                }

                public void onEvent(ServerSentEvent event) {
                    completableFuture.completeExceptionally(new IllegalStateException("onEvent() should not be called"));
                }

                public void onError(Throwable throwable) {
                    this.threads.add(Thread.currentThread());
                    record StreamingResult(Throwable throwable, Set<Thread> threads) {
                    }
                    completableFuture.complete(new StreamingResult(throwable, this.threads));
                }

                public void onClose() {
                    completableFuture.completeExceptionally(new IllegalStateException("onClose() should not be called"));
                }
            };
            ServerSentEventListener spyListener = (ServerSentEventListener)Mockito.spy((Object)listener);
            client.execute(request, (ServerSentEventParser)new DefaultServerSentEventParser(), spyListener);
            StreamingResult streamingResult = (StreamingResult)completableFuture.get(readTimeoutMillis * 3, TimeUnit.MILLISECONDS);
            ((AbstractThrowableAssert)Assertions.assertThat((Throwable)streamingResult.throwable()).isExactlyInstanceOf(TimeoutException.class)).hasRootCauseExactlyInstanceOf(this.expectedReadTimeoutRootCauseExceptionType()).hasMessageContainingAll(new CharSequence[]{"time", "out"});
            Assertions.assertThat(streamingResult.threads()).hasSize(1);
            Assertions.assertThat((Object)streamingResult.threads().iterator().next()).isNotEqualTo((Object)Thread.currentThread());
            ((ServerSentEventListener)Mockito.verify((Object)spyListener, (VerificationMode)Mockito.times((int)1))).onError((Throwable)ArgumentMatchers.any());
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{spyListener});
        }
    }
}

