/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.store.embedding.elasticsearch;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch._types.ElasticsearchException;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.ScriptScoreQuery;
import co.elastic.clients.elasticsearch.core.SearchRequest;
import co.elastic.clients.elasticsearch.core.SearchResponse;
import co.elastic.clients.json.JsonData;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import dev.langchain4j.store.embedding.EmbeddingSearchRequest;
import dev.langchain4j.store.embedding.elasticsearch.Document;
import dev.langchain4j.store.embedding.elasticsearch.ElasticsearchConfiguration;
import dev.langchain4j.store.embedding.elasticsearch.ElasticsearchMetadataFilterMapper;
import dev.langchain4j.store.embedding.filter.Filter;
import java.io.IOException;

public class ElasticsearchConfigurationScript
extends ElasticsearchConfiguration {
    private final ObjectMapper objectMapper = new ObjectMapper();

    public static Builder builder() {
        return new Builder();
    }

    private ElasticsearchConfigurationScript() {
    }

    @Override
    SearchResponse<Document> internalSearch(ElasticsearchClient client, String indexName, EmbeddingSearchRequest embeddingSearchRequest) throws ElasticsearchException, IOException {
        ScriptScoreQuery scriptScoreQuery = this.buildDefaultScriptScoreQuery(embeddingSearchRequest.queryEmbedding().vector(), (float)embeddingSearchRequest.minScore(), embeddingSearchRequest.filter());
        return client.search(SearchRequest.of(s -> s.index(indexName, new String[0]).query(n -> n.scriptScore(scriptScoreQuery)).size(Integer.valueOf(embeddingSearchRequest.maxResults()))), Document.class);
    }

    private ScriptScoreQuery buildDefaultScriptScoreQuery(float[] vector, float minScore, Filter filter) throws JsonProcessingException {
        JsonData queryVector = this.toJsonData(vector);
        Query query = filter == null ? Query.of(q -> q.matchAll(m -> m)) : ElasticsearchMetadataFilterMapper.map(filter);
        return ScriptScoreQuery.of(q -> q.minScore(Float.valueOf(minScore)).query(query).script(s -> s.source("(cosineSimilarity(params.query_vector, 'vector') + 1.0) / 2").params("query_vector", queryVector)));
    }

    private <T> JsonData toJsonData(T rawData) throws JsonProcessingException {
        return JsonData.fromJson((String)this.objectMapper.writeValueAsString(rawData));
    }

    public static class Builder {
        public ElasticsearchConfigurationScript build() {
            return new ElasticsearchConfigurationScript();
        }
    }
}

