/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.data.document.source.github;

import dev.langchain4j.data.document.DocumentSource;
import dev.langchain4j.data.document.Metadata;
import dev.langchain4j.internal.ValidationUtils;
import java.io.IOException;
import java.io.InputStream;
import org.kohsuke.github.GHContent;

public class GitHubSource
implements DocumentSource {
    private final InputStream inputStream;
    private final GHContent content;

    public GitHubSource(GHContent content) throws IOException {
        this.content = (GHContent)ValidationUtils.ensureNotNull((Object)content, (String)"content");
        this.inputStream = (InputStream)ValidationUtils.ensureNotNull((Object)content.read(), (String)"inputStream");
    }

    public InputStream inputStream() {
        return this.inputStream;
    }

    public Metadata metadata() {
        Metadata metadata = new Metadata();
        metadata.put("github_git_url", this.content.getGitUrl());
        try {
            metadata.put("github_download_url", this.content.getDownloadUrl());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        metadata.put("github_html_url", this.content.getHtmlUrl());
        metadata.put("github_url", this.content.getUrl());
        metadata.put("github_file_name", this.content.getName());
        metadata.put("github_file_path", this.content.getPath());
        metadata.put("github_file_sha", this.content.getSha());
        metadata.put("github_file_size", Long.toString(this.content.getSize()));
        metadata.put("github_file_encoding", this.content.getEncoding());
        return metadata;
    }
}

