/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.community.store.embedding.duckdb;

import dev.langchain4j.store.embedding.filter.Filter;
import dev.langchain4j.store.embedding.filter.comparison.IsEqualTo;
import dev.langchain4j.store.embedding.filter.comparison.IsGreaterThan;
import dev.langchain4j.store.embedding.filter.comparison.IsGreaterThanOrEqualTo;
import dev.langchain4j.store.embedding.filter.comparison.IsIn;
import dev.langchain4j.store.embedding.filter.comparison.IsLessThan;
import dev.langchain4j.store.embedding.filter.comparison.IsLessThanOrEqualTo;
import dev.langchain4j.store.embedding.filter.comparison.IsNotEqualTo;
import dev.langchain4j.store.embedding.filter.comparison.IsNotIn;
import dev.langchain4j.store.embedding.filter.logical.And;
import dev.langchain4j.store.embedding.filter.logical.Not;
import dev.langchain4j.store.embedding.filter.logical.Or;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DuckDBMetadataFilterMapper {
    static final Map<Class<?>, String> SQL_TYPE_MAP = Stream.of(new AbstractMap.SimpleEntry<Class<Integer>, String>(Integer.class, "int"), new AbstractMap.SimpleEntry<Class<Long>, String>(Long.class, "bigint"), new AbstractMap.SimpleEntry<Class<Float>, String>(Float.class, "float"), new AbstractMap.SimpleEntry<Class<Double>, String>(Double.class, "double"), new AbstractMap.SimpleEntry<Class<String>, String>(String.class, "text"), new AbstractMap.SimpleEntry<Class<UUID>, String>(UUID.class, "uuid"), new AbstractMap.SimpleEntry<Class<Boolean>, String>(Boolean.class, "boolean"), new AbstractMap.SimpleEntry<Class<Object>, String>(Object.class, "text")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));

    public String map(Filter filter) {
        if (filter instanceof IsEqualTo) {
            IsEqualTo eq = (IsEqualTo)filter;
            return this.mapEqual(eq);
        }
        if (filter instanceof IsNotEqualTo) {
            IsNotEqualTo neq = (IsNotEqualTo)filter;
            return this.mapNotEqual(neq);
        }
        if (filter instanceof IsGreaterThan) {
            IsGreaterThan gt = (IsGreaterThan)filter;
            return this.mapGreaterThan(gt);
        }
        if (filter instanceof IsGreaterThanOrEqualTo) {
            IsGreaterThanOrEqualTo gte = (IsGreaterThanOrEqualTo)filter;
            return this.mapGreaterThanOrEqual(gte);
        }
        if (filter instanceof IsLessThan) {
            IsLessThan lt = (IsLessThan)filter;
            return this.mapLessThan(lt);
        }
        if (filter instanceof IsLessThanOrEqualTo) {
            IsLessThanOrEqualTo lte = (IsLessThanOrEqualTo)filter;
            return this.mapLessThanOrEqual(lte);
        }
        if (filter instanceof IsIn) {
            IsIn in = (IsIn)filter;
            return this.mapIn(in);
        }
        if (filter instanceof IsNotIn) {
            IsNotIn nin = (IsNotIn)filter;
            return this.mapNotIn(nin);
        }
        if (filter instanceof And) {
            And and = (And)filter;
            return this.mapAnd(and);
        }
        if (filter instanceof Not) {
            Not not = (Not)filter;
            return this.mapNot(not);
        }
        if (filter instanceof Or) {
            Or or = (Or)filter;
            return this.mapOr(or);
        }
        throw new UnsupportedOperationException("Unsupported filter type: " + filter.getClass().getName());
    }

    private String mapEqual(IsEqualTo isEqualTo) {
        String key = this.formatKey(isEqualTo.key(), isEqualTo.comparisonValue().getClass());
        return String.format("%s is not null and %s = %s", key, key, this.formatValue(isEqualTo.comparisonValue()));
    }

    private String mapNotEqual(IsNotEqualTo isNotEqualTo) {
        String key = this.formatKey(isNotEqualTo.key(), isNotEqualTo.comparisonValue().getClass());
        return String.format("%s is null or %s != %s", key, key, this.formatValue(isNotEqualTo.comparisonValue()));
    }

    private String mapGreaterThan(IsGreaterThan isGreaterThan) {
        return String.format("%s > %s", this.formatKey(isGreaterThan.key(), isGreaterThan.comparisonValue().getClass()), this.formatValue(isGreaterThan.comparisonValue()));
    }

    private String mapGreaterThanOrEqual(IsGreaterThanOrEqualTo isGreaterThanOrEqualTo) {
        return String.format("%s >= %s", this.formatKey(isGreaterThanOrEqualTo.key(), isGreaterThanOrEqualTo.comparisonValue().getClass()), this.formatValue(isGreaterThanOrEqualTo.comparisonValue()));
    }

    private String mapLessThan(IsLessThan isLessThan) {
        return String.format("%s < %s", this.formatKey(isLessThan.key(), isLessThan.comparisonValue().getClass()), this.formatValue(isLessThan.comparisonValue()));
    }

    private String mapLessThanOrEqual(IsLessThanOrEqualTo isLessThanOrEqualTo) {
        return String.format("%s <= %s", this.formatKey(isLessThanOrEqualTo.key(), isLessThanOrEqualTo.comparisonValue().getClass()), this.formatValue(isLessThanOrEqualTo.comparisonValue()));
    }

    private String mapIn(IsIn isIn) {
        return String.format("%s in %s", this.formatKeyAsString(isIn.key()), this.formatValuesAsString(isIn.comparisonValues()));
    }

    private String mapNotIn(IsNotIn isNotIn) {
        String key = this.formatKeyAsString(isNotIn.key());
        return String.format("%s is null or %s not in %s", key, key, this.formatValuesAsString(isNotIn.comparisonValues()));
    }

    private String mapAnd(And and) {
        return String.format("%s and %s", this.map(and.left()), this.map(and.right()));
    }

    private String mapNot(Not not) {
        return String.format("not(%s)", this.map(not.expression()));
    }

    private String mapOr(Or or) {
        return String.format("(%s or %s)", this.map(or.left()), this.map(or.right()));
    }

    String formatKey(String key, Class<?> valueType) {
        return String.format("(metadata->>'%s')::%s", key, SQL_TYPE_MAP.get(valueType));
    }

    String formatKeyAsString(String key) {
        return String.format("(metadata->>'%s')", key);
    }

    String formatValue(Object value) {
        if (value instanceof String || value instanceof UUID) {
            return "'" + String.valueOf(value) + "'";
        }
        return value.toString();
    }

    String formatValuesAsString(Collection<?> values) {
        return "(" + values.stream().map((? super T v) -> String.format("'%s'", v)).collect(Collectors.joining(",")) + ")";
    }
}

