/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.community.store.embedding.clickhouse;

import com.clickhouse.data.ClickHouseDataType;
import dev.langchain4j.store.embedding.filter.Filter;
import dev.langchain4j.store.embedding.filter.comparison.ContainsString;
import dev.langchain4j.store.embedding.filter.comparison.IsEqualTo;
import dev.langchain4j.store.embedding.filter.comparison.IsGreaterThan;
import dev.langchain4j.store.embedding.filter.comparison.IsGreaterThanOrEqualTo;
import dev.langchain4j.store.embedding.filter.comparison.IsIn;
import dev.langchain4j.store.embedding.filter.comparison.IsLessThan;
import dev.langchain4j.store.embedding.filter.comparison.IsLessThanOrEqualTo;
import dev.langchain4j.store.embedding.filter.comparison.IsNotEqualTo;
import dev.langchain4j.store.embedding.filter.comparison.IsNotIn;
import dev.langchain4j.store.embedding.filter.logical.And;
import dev.langchain4j.store.embedding.filter.logical.Not;
import dev.langchain4j.store.embedding.filter.logical.Or;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;

class ClickHouseMetadataFilterMapper {
    private final Map<String, String> columnMap;
    private final Map<String, ClickHouseDataType> typeMap;

    ClickHouseMetadataFilterMapper(Map<String, String> columnMap, Map<String, ClickHouseDataType> typeMap) {
        this.columnMap = columnMap;
        this.typeMap = typeMap;
    }

    String map(Filter filter) {
        if (filter instanceof IsEqualTo) {
            IsEqualTo isEqualTo = (IsEqualTo)filter;
            return this.mapEqual(isEqualTo);
        }
        if (filter instanceof IsNotEqualTo) {
            IsNotEqualTo isNotEqualTo = (IsNotEqualTo)filter;
            return this.mapNotEqual(isNotEqualTo);
        }
        if (filter instanceof IsGreaterThan) {
            IsGreaterThan isGreaterThan = (IsGreaterThan)filter;
            return this.mapGreaterThan(isGreaterThan);
        }
        if (filter instanceof IsGreaterThanOrEqualTo) {
            IsGreaterThanOrEqualTo isGreaterThanOrEqualTo = (IsGreaterThanOrEqualTo)filter;
            return this.mapGreaterThanOrEqual(isGreaterThanOrEqualTo);
        }
        if (filter instanceof IsLessThan) {
            IsLessThan isLessThan = (IsLessThan)filter;
            return this.mapLessThan(isLessThan);
        }
        if (filter instanceof IsLessThanOrEqualTo) {
            IsLessThanOrEqualTo isLessThanOrEqualTo = (IsLessThanOrEqualTo)filter;
            return this.mapLessThanOrEqual(isLessThanOrEqualTo);
        }
        if (filter instanceof IsIn) {
            IsIn isIn = (IsIn)filter;
            return this.mapIn(isIn);
        }
        if (filter instanceof IsNotIn) {
            IsNotIn isNotIn = (IsNotIn)filter;
            return this.mapNotIn(isNotIn);
        }
        if (filter instanceof ContainsString) {
            ContainsString containsString = (ContainsString)filter;
            return this.mapContains(containsString);
        }
        if (filter instanceof And) {
            And and = (And)filter;
            return this.mapAnd(and);
        }
        if (filter instanceof Not) {
            Not not = (Not)filter;
            return this.mapNot(not);
        }
        if (filter instanceof Or) {
            Or or = (Or)filter;
            return this.mapOr(or);
        }
        throw new UnsupportedOperationException("Unsupported filter type: " + filter.getClass().getName());
    }

    private String mapEqual(IsEqualTo isEqualTo) {
        return this.mapBinaryOperation(isEqualTo.key(), "==", this.handleSingleValue(isEqualTo.key(), isEqualTo.comparisonValue()));
    }

    private String mapNotEqual(IsNotEqualTo isNotEqualTo) {
        return this.mapBinaryOperation(this.mapBinaryOperation(isNotEqualTo.key(), "<>", this.handleSingleValue(isNotEqualTo.key(), isNotEqualTo.comparisonValue())), "OR", this.mapIsNull(isNotEqualTo.key()));
    }

    private String mapGreaterThan(IsGreaterThan isGreaterThan) {
        return this.mapBinaryOperation(isGreaterThan.key(), ">", this.handleSingleValue(isGreaterThan.key(), isGreaterThan.comparisonValue()));
    }

    private String mapGreaterThanOrEqual(IsGreaterThanOrEqualTo isGreaterThanOrEqualTo) {
        return this.mapBinaryOperation(isGreaterThanOrEqualTo.key(), ">=", this.handleSingleValue(isGreaterThanOrEqualTo.key(), isGreaterThanOrEqualTo.comparisonValue()));
    }

    private String mapLessThan(IsLessThan isLessThan) {
        return this.mapBinaryOperation(isLessThan.key(), "<", this.handleSingleValue(isLessThan.key(), isLessThan.comparisonValue()));
    }

    private String mapLessThanOrEqual(IsLessThanOrEqualTo isLessThanOrEqualTo) {
        return this.mapBinaryOperation(isLessThanOrEqualTo.key(), "<=", this.handleSingleValue(isLessThanOrEqualTo.key(), isLessThanOrEqualTo.comparisonValue()));
    }

    public String mapIn(IsIn isIn) {
        return this.mapBinaryOperation(isIn.key(), "IN", this.handleMultiValue(isIn.key(), isIn.comparisonValues()));
    }

    public String mapNotIn(IsNotIn isNotIn) {
        return this.mapBinaryOperation(this.mapBinaryOperation(isNotIn.key(), "NOT IN", this.handleMultiValue(isNotIn.key(), isNotIn.comparisonValues())), "OR", this.mapIsNull(isNotIn.key()));
    }

    public String mapContains(ContainsString containsString) {
        return this.mapBinaryOperation(containsString.key(), "LIKE", this.handleSingleValue(containsString.key(), "%" + containsString.comparisonValue() + "%"));
    }

    private String mapAnd(And and) {
        return this.mapBinaryOperation(this.map(and.left()), "AND", this.map(and.right()));
    }

    private String mapNot(Not not) {
        String expression = this.map(not.expression());
        return this.mapBinaryOperation(this.mapUnaryOperation("NOT", expression), "OR", this.mapIsNull(expression));
    }

    private String mapOr(Or or) {
        return this.mapBinaryOperation(this.map(or.left()), "OR", this.map(or.right()));
    }

    private String handleSingleValue(String key, Object value) {
        boolean isIdOrText;
        boolean bl = isIdOrText = key.equals(this.columnMap.get("id")) || key.equals(this.columnMap.get("text"));
        if (isIdOrText || this.typeMap.get(key) == ClickHouseDataType.UUID || this.typeMap.get(key) == ClickHouseDataType.String) {
            value = "'" + String.valueOf(value) + "'";
        }
        return value.toString();
    }

    private String handleMultiValue(String key, Collection<?> values) {
        boolean isIdOrText;
        boolean bl = isIdOrText = key.equals(this.columnMap.get("id")) || key.equals(this.columnMap.get("text"));
        if (isIdOrText || this.typeMap.get(key) == ClickHouseDataType.UUID || this.typeMap.get(key) == ClickHouseDataType.String) {
            values = values.stream().map((? super T value) -> "'" + String.valueOf(value) + "'").collect(Collectors.toList());
        }
        return "[" + values.stream().map(Object::toString).collect(Collectors.joining(",")) + "]";
    }

    private String mapBinaryOperation(String left, String operator, String right) {
        return "(" + String.join((CharSequence)" ", left, operator, right) + ")";
    }

    private String mapIsNull(String key) {
        return this.mapUnaryOperation(key, "IS NULL");
    }

    private String mapUnaryOperation(String firstEle, String secondEle) {
        return "(" + String.join((CharSequence)" ", firstEle, secondEle) + ")";
    }
}

