/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.community.store.embedding.clickhouse;

import com.clickhouse.data.ClickHouseDataType;
import dev.langchain4j.community.store.embedding.clickhouse.ClickHouseMappingKey;
import dev.langchain4j.internal.Exceptions;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import java.util.Map;

public class ClickHouseSettings {
    private static final Map<String, String> DEFAULT_COLUMN_MAP = Map.of("text", "text", "id", "id", "embedding", "embedding");
    private String url;
    private String username;
    private String password;
    private String database;
    private String table;
    private Map<String, String> columnMap;
    private Map<String, ClickHouseDataType> metadataTypeMap;
    private Integer dimension;
    private Long timeout;

    public ClickHouseSettings(String url, String username, String password, String database, String table, Map<String, String> columnMap, Map<String, ClickHouseDataType> metadataTypeMap, Integer dimension, Long timeout) {
        this.url = (String)ValidationUtils.ensureNotNull((Object)url, (String)"url");
        this.username = username;
        this.password = password;
        this.database = (String)Utils.getOrDefault((Object)database, (Object)"default");
        this.table = (String)Utils.getOrDefault((Object)table, (Object)"langchain4j_table");
        this.columnMap = Utils.getOrDefault(columnMap, DEFAULT_COLUMN_MAP);
        this.metadataTypeMap = metadataTypeMap;
        this.dimension = (Integer)ValidationUtils.ensureNotNull((Object)dimension, (String)"dimension");
        this.timeout = (Long)Utils.getOrDefault((Object)timeout, (Object)3000L);
        ClickHouseSettings.ensureColumnMap(this.columnMap);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public Map<String, String> getColumnMap() {
        return this.columnMap;
    }

    public Map<String, ClickHouseDataType> getMetadataTypeMap() {
        return this.metadataTypeMap;
    }

    public void setMetadataTypeMap(Map<String, ClickHouseDataType> metadataTypeMap) {
        this.metadataTypeMap = metadataTypeMap;
    }

    public void setColumnMap(Map<String, String> columnMap) {
        this.columnMap = columnMap;
    }

    public Integer getDimension() {
        return this.dimension;
    }

    public void setDimension(Integer dimension) {
        this.dimension = dimension;
    }

    public Long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Long timeout) {
        this.timeout = timeout;
    }

    public boolean containsMetadata() {
        return this.metadataTypeMap != null && !this.metadataTypeMap.isEmpty();
    }

    public boolean containsMetadataKey(String key) {
        return this.containsMetadata() && this.metadataTypeMap.containsKey(key);
    }

    public String getColumnMapping(String key) {
        return this.columnMap.get(key);
    }

    private static void ensureColumnMap(Map<String, String> columnMap) {
        ClickHouseMappingKey.REQUIRED_COLUMN_MAP_KEYS.forEach(requiredColumn -> {
            if (!columnMap.containsKey(requiredColumn)) {
                throw Exceptions.illegalArgument((String)"ColumnMap must contains key %s", (Object[])new Object[]{requiredColumn});
            }
        });
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String url;
        private String username;
        private String password;
        private String database;
        private String table;
        private Map<String, String> columnMap;
        private Map<String, ClickHouseDataType> metadataTypeMap;
        private Integer dimension;
        private Long timeout;

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder database(String database) {
            this.database = database;
            return this;
        }

        public Builder table(String table) {
            this.table = table;
            return this;
        }

        public Builder columnMap(Map<String, String> columnMap) {
            this.columnMap = columnMap;
            return this;
        }

        public Builder metadataTypeMap(Map<String, ClickHouseDataType> metadataTypeMap) {
            this.metadataTypeMap = metadataTypeMap;
            return this;
        }

        public Builder dimension(Integer dimension) {
            this.dimension = dimension;
            return this;
        }

        public Builder timeout(Long timeout) {
            this.timeout = timeout;
            return this;
        }

        public ClickHouseSettings build() {
            return new ClickHouseSettings(this.url, this.username, this.password, this.database, this.table, this.columnMap, this.metadataTypeMap, this.dimension, this.timeout);
        }
    }
}

