/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.community.store.embedding.clickhouse;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;

class ClickHouseJsonUtils {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    private ClickHouseJsonUtils() throws InstantiationException {
        throw new InstantiationException("Can't instantiate this utility class.");
    }

    static String toJson(Object object) {
        try {
            return OBJECT_MAPPER.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    static <T> T toObject(String jsonStr, Class<T> clazz) {
        try {
            return (T)OBJECT_MAPPER.readValue(jsonStr, clazz);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    static <T> T toObject(String jsonStr, TypeReference<T> typeReference) {
        try {
            return (T)OBJECT_MAPPER.readValue(jsonStr, typeReference);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    static String emptyJson() {
        try {
            ObjectNode emptyJson = OBJECT_MAPPER.createObjectNode();
            return OBJECT_MAPPER.writeValueAsString((Object)emptyJson);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

