/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.community.store.embedding.alloydb.index.query;

import dev.langchain4j.community.store.embedding.alloydb.index.query.QueryOptions;
import java.util.List;

public class ScaNNIndexQueryOptions
implements QueryOptions {
    private final Integer numLeavesToSearch;
    private final Integer preOrderingNumNeighbors;

    public ScaNNIndexQueryOptions(Builder builder) {
        this.numLeavesToSearch = builder.numLeavesToSearch;
        this.preOrderingNumNeighbors = builder.preOrderingNumNeighbors;
    }

    @Override
    public List<String> getParameterSettings() {
        return List.of("scann.num_leaves_to_search = " + this.numLeavesToSearch, "scann.pre_reordering_num_neighbors = " + this.preOrderingNumNeighbors);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Integer numLeavesToSearch = 1;
        private Integer preOrderingNumNeighbors = -1;

        public Builder numLeavesToSearch(Integer numLeavesToSearch) {
            this.numLeavesToSearch = numLeavesToSearch;
            return this;
        }

        public Builder preOrderingNumNeighbors(Integer preOrderingNumNeighbors) {
            this.preOrderingNumNeighbors = preOrderingNumNeighbors;
            return this;
        }

        public ScaNNIndexQueryOptions build() {
            return new ScaNNIndexQueryOptions(this);
        }
    }
}

