/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.azure;

import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.HttpResponse;
import dev.langchain4j.Internal;
import dev.langchain4j.exception.ContentFilteredException;
import dev.langchain4j.exception.LangChain4jException;
import dev.langchain4j.internal.ExceptionMapper;
import io.netty.channel.ConnectTimeoutException;
import java.util.Map;
import java.util.concurrent.TimeoutException;

@Internal
class AzureOpenAiExceptionMapper
extends ExceptionMapper.DefaultExceptionMapper {
    static final AzureOpenAiExceptionMapper INSTANCE = new AzureOpenAiExceptionMapper();

    AzureOpenAiExceptionMapper() {
    }

    public RuntimeException mapException(Throwable t) {
        Object object;
        if (t instanceof HttpResponseException) {
            Map errorMap;
            Object v;
            Map map;
            HttpResponseException httpResponseException = (HttpResponseException)t;
            Object object2 = httpResponseException.getValue();
            if (object2 instanceof Map && (map = (Map)object2).containsKey("error") && (v = map.get("error")) instanceof Map && "content_filter".equals((errorMap = (Map)v).get("code"))) {
                return new ContentFilteredException(t);
            }
            HttpResponse httpResponse = httpResponseException.getResponse();
            if (httpResponse != null) {
                return this.mapHttpStatusCode((Throwable)httpResponseException, httpResponse.getStatusCode());
            }
        }
        if (t instanceof ConnectTimeoutException || t instanceof TimeoutException) {
            return new dev.langchain4j.exception.TimeoutException(t);
        }
        if (t.getCause() instanceof ConnectTimeoutException || t.getCause() instanceof TimeoutException) {
            return new dev.langchain4j.exception.TimeoutException(t.getCause());
        }
        if (t instanceof RuntimeException) {
            RuntimeException re = (RuntimeException)t;
            object = re;
        } else {
            object = new LangChain4jException(t);
        }
        return object;
    }
}

