/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.azure.openai.spring;

import com.azure.core.http.ProxyOptions;
import com.azure.core.util.Configuration;
import dev.langchain4j.azure.openai.spring.ChatModelProperties;
import dev.langchain4j.azure.openai.spring.EmbeddingModelProperties;
import dev.langchain4j.azure.openai.spring.ImageModelProperties;
import dev.langchain4j.azure.openai.spring.Properties;
import dev.langchain4j.model.azure.AzureOpenAiChatModel;
import dev.langchain4j.model.azure.AzureOpenAiEmbeddingModel;
import dev.langchain4j.model.azure.AzureOpenAiImageModel;
import dev.langchain4j.model.azure.AzureOpenAiStreamingChatModel;
import dev.langchain4j.model.chat.listener.ChatModelListener;
import java.time.Duration;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@EnableConfigurationProperties(value={Properties.class})
public class AutoConfig {
    @Bean
    @ConditionalOnProperty(value={"langchain4j.azure-open-ai.chat-model.api-key"})
    AzureOpenAiChatModel openAiChatModelByAPIKey(Properties properties, ObjectProvider<ChatModelListener> listeners) {
        return this.openAiChatModel(properties, listeners);
    }

    @Bean
    @ConditionalOnProperty(value={"langchain4j.azure-open-ai.chat-model.non-azure-api-key"})
    AzureOpenAiChatModel openAiChatModelByNonAzureApiKey(Properties properties, ObjectProvider<ChatModelListener> listeners) {
        return this.openAiChatModel(properties, listeners);
    }

    AzureOpenAiChatModel openAiChatModel(Properties properties, ObjectProvider<ChatModelListener> listeners) {
        ChatModelProperties chatModelProperties = properties.chatModel();
        AzureOpenAiChatModel.Builder builder = AzureOpenAiChatModel.builder().endpoint(chatModelProperties.endpoint()).serviceVersion(chatModelProperties.serviceVersion()).apiKey(chatModelProperties.apiKey()).deploymentName(chatModelProperties.deploymentName()).maxTokens(chatModelProperties.maxTokens()).maxCompletionTokens(chatModelProperties.maxCompletionTokens()).temperature(chatModelProperties.temperature()).topP(chatModelProperties.topP()).logitBias(chatModelProperties.logitBias()).user(chatModelProperties.user()).stop(chatModelProperties.stop()).presencePenalty(chatModelProperties.presencePenalty()).frequencyPenalty(chatModelProperties.frequencyPenalty()).seed(chatModelProperties.seed()).strictJsonSchema(chatModelProperties.strictJsonSchema()).timeout(Duration.ofSeconds(chatModelProperties.timeout() == null ? 0L : (long)chatModelProperties.timeout().intValue())).maxRetries(chatModelProperties.maxRetries()).proxyOptions(ProxyOptions.fromConfiguration((Configuration)Configuration.getGlobalConfiguration())).logRequestsAndResponses(Boolean.valueOf(chatModelProperties.logRequestsAndResponses() != null && chatModelProperties.logRequestsAndResponses() != false)).userAgentSuffix(chatModelProperties.userAgentSuffix()).listeners(listeners.orderedStream().toList()).customHeaders(chatModelProperties.customHeaders()).supportedCapabilities(chatModelProperties.supportedCapabilities());
        if (chatModelProperties.nonAzureApiKey() != null) {
            builder.nonAzureApiKey(chatModelProperties.nonAzureApiKey());
        }
        return builder.build();
    }

    @Bean
    @ConditionalOnProperty(value={"langchain4j.azure-open-ai.streaming-chat-model.api-key"})
    AzureOpenAiStreamingChatModel openAiStreamingChatModelByApiKey(Properties properties, ObjectProvider<ChatModelListener> listeners) {
        return this.openAiStreamingChatModel(properties, listeners);
    }

    @Bean
    @ConditionalOnProperty(value={"langchain4j.azure-open-ai.streaming-chat-model.non-azure-api-key"})
    AzureOpenAiStreamingChatModel openAiStreamingChatModelByNonAzureApiKey(Properties properties, ObjectProvider<ChatModelListener> listeners) {
        return this.openAiStreamingChatModel(properties, listeners);
    }

    AzureOpenAiStreamingChatModel openAiStreamingChatModel(Properties properties, ObjectProvider<ChatModelListener> listeners) {
        ChatModelProperties chatModelProperties = properties.streamingChatModel();
        AzureOpenAiStreamingChatModel.Builder builder = AzureOpenAiStreamingChatModel.builder().endpoint(chatModelProperties.endpoint()).serviceVersion(chatModelProperties.serviceVersion()).apiKey(chatModelProperties.apiKey()).deploymentName(chatModelProperties.deploymentName()).maxTokens(chatModelProperties.maxTokens()).maxCompletionTokens(chatModelProperties.maxCompletionTokens()).temperature(chatModelProperties.temperature()).topP(chatModelProperties.topP()).logitBias(chatModelProperties.logitBias()).user(chatModelProperties.user()).stop(chatModelProperties.stop()).presencePenalty(chatModelProperties.presencePenalty()).frequencyPenalty(chatModelProperties.frequencyPenalty()).seed(chatModelProperties.seed()).timeout(Duration.ofSeconds(chatModelProperties.timeout() == null ? 0L : (long)chatModelProperties.timeout().intValue())).maxRetries(chatModelProperties.maxRetries()).proxyOptions(ProxyOptions.fromConfiguration((Configuration)Configuration.getGlobalConfiguration())).logRequestsAndResponses(chatModelProperties.logRequestsAndResponses() != null && chatModelProperties.logRequestsAndResponses() != false).userAgentSuffix(chatModelProperties.userAgentSuffix()).listeners(listeners.orderedStream().toList()).customHeaders(chatModelProperties.customHeaders()).supportedCapabilities(chatModelProperties.supportedCapabilities());
        if (chatModelProperties.nonAzureApiKey() != null) {
            builder.nonAzureApiKey(chatModelProperties.nonAzureApiKey());
        }
        return builder.build();
    }

    @Bean
    @ConditionalOnProperty(value={"langchain4j.azure-open-ai.embedding-model.api-key"})
    AzureOpenAiEmbeddingModel openAiEmbeddingModelByApiKey(Properties properties) {
        return this.openAiEmbeddingModel(properties);
    }

    @Bean
    @ConditionalOnProperty(value={"langchain4j.azure-open-ai.embedding-model.non-azure-api-key"})
    AzureOpenAiEmbeddingModel openAiEmbeddingModelByNonAzureApiKey(Properties properties) {
        return this.openAiEmbeddingModel(properties);
    }

    AzureOpenAiEmbeddingModel openAiEmbeddingModel(Properties properties) {
        EmbeddingModelProperties embeddingModelProperties = properties.embeddingModel();
        AzureOpenAiEmbeddingModel.Builder builder = AzureOpenAiEmbeddingModel.builder().endpoint(embeddingModelProperties.endpoint()).serviceVersion(embeddingModelProperties.serviceVersion()).apiKey(embeddingModelProperties.apiKey()).deploymentName(embeddingModelProperties.deploymentName()).timeout(Duration.ofSeconds(embeddingModelProperties.timeout() == null ? 0L : (long)embeddingModelProperties.timeout().intValue())).maxRetries(embeddingModelProperties.maxRetries()).proxyOptions(ProxyOptions.fromConfiguration((Configuration)Configuration.getGlobalConfiguration())).logRequestsAndResponses(embeddingModelProperties.logRequestsAndResponses() != null && embeddingModelProperties.logRequestsAndResponses() != false).userAgentSuffix(embeddingModelProperties.userAgentSuffix()).dimensions(embeddingModelProperties.dimensions()).customHeaders(embeddingModelProperties.customHeaders());
        if (embeddingModelProperties.nonAzureApiKey() != null) {
            builder.nonAzureApiKey(embeddingModelProperties.nonAzureApiKey());
        }
        return builder.build();
    }

    @Bean
    @ConditionalOnProperty(value={"langchain4j.azure-open-ai.image-model.api-key"})
    AzureOpenAiImageModel openAiImageModelByApiKey(Properties properties) {
        return this.openAiImageModel(properties);
    }

    @Bean
    @ConditionalOnProperty(value={"langchain4j.azure-open-ai.image-model.non-azure-api-key"})
    AzureOpenAiImageModel openAiImageModelByNonAzureApiKey(Properties properties) {
        return this.openAiImageModel(properties);
    }

    AzureOpenAiImageModel openAiImageModel(Properties properties) {
        ImageModelProperties imageModelProperties = properties.imageModel();
        AzureOpenAiImageModel.Builder builder = AzureOpenAiImageModel.builder().endpoint(imageModelProperties.endpoint()).serviceVersion(imageModelProperties.serviceVersion()).apiKey(imageModelProperties.apiKey()).deploymentName(imageModelProperties.deploymentName()).quality(imageModelProperties.quality()).size(imageModelProperties.size()).user(imageModelProperties.user()).style(imageModelProperties.style()).responseFormat(imageModelProperties.responseFormat()).timeout(imageModelProperties.timeout() == null ? null : Duration.ofSeconds(imageModelProperties.timeout().intValue())).maxRetries(imageModelProperties.maxRetries()).proxyOptions(ProxyOptions.fromConfiguration((Configuration)Configuration.getGlobalConfiguration())).logRequestsAndResponses(Boolean.valueOf(imageModelProperties.logRequestsAndResponses() != null && imageModelProperties.logRequestsAndResponses() != false)).userAgentSuffix(imageModelProperties.userAgentSuffix()).customHeaders(imageModelProperties.customHeaders());
        if (imageModelProperties.nonAzureApiKey() != null) {
            builder.nonAzureApiKey(imageModelProperties.nonAzureApiKey());
        }
        return builder.build();
    }
}

