/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.rag.content.retriever.azure.cosmos.nosql;

import dev.langchain4j.rag.content.retriever.azure.cosmos.nosql.AzureCosmosDBNoSqlFilterMapper;
import dev.langchain4j.rag.content.retriever.azure.cosmos.nosql.FullTextContains;
import dev.langchain4j.rag.content.retriever.azure.cosmos.nosql.FullTextContainsAll;
import dev.langchain4j.rag.content.retriever.azure.cosmos.nosql.FullTextContainsAny;
import dev.langchain4j.store.embedding.filter.Filter;
import dev.langchain4j.store.embedding.filter.comparison.ContainsString;
import dev.langchain4j.store.embedding.filter.comparison.IsEqualTo;
import dev.langchain4j.store.embedding.filter.comparison.IsGreaterThan;
import dev.langchain4j.store.embedding.filter.comparison.IsGreaterThanOrEqualTo;
import dev.langchain4j.store.embedding.filter.comparison.IsIn;
import dev.langchain4j.store.embedding.filter.comparison.IsLessThan;
import dev.langchain4j.store.embedding.filter.comparison.IsLessThanOrEqualTo;
import dev.langchain4j.store.embedding.filter.comparison.IsNotEqualTo;
import dev.langchain4j.store.embedding.filter.comparison.IsNotIn;
import dev.langchain4j.store.embedding.filter.logical.And;
import dev.langchain4j.store.embedding.filter.logical.Not;
import dev.langchain4j.store.embedding.filter.logical.Or;
import java.util.Collection;
import java.util.stream.Collectors;

public class DefaultAzureCosmosDBNoSqlFilterMapper
implements AzureCosmosDBNoSqlFilterMapper {
    @Override
    public String map(Filter filter) {
        if (filter == null) {
            return "";
        }
        if (this.isLogicalOperator(filter)) {
            return this.mapLogicalOperator(filter);
        }
        return this.mapComparisonFilter(filter);
    }

    private String mapLogicalOperator(Filter operator) {
        if (operator instanceof And) {
            return String.format(this.getLogicalFormat(operator), this.map(((And)operator).left()), this.map(((And)operator).right()));
        }
        if (operator instanceof Or) {
            return String.format(this.getLogicalFormat(operator), this.map(((Or)operator).left()), this.map(((Or)operator).right()));
        }
        if (operator instanceof Not) {
            return String.format(this.getLogicalFormat(operator), this.map(((Not)operator).expression()));
        }
        throw new UnsupportedOperationException("Unsupported filter type: " + operator.getClass().getName());
    }

    private boolean isLogicalOperator(Filter filter) {
        return filter instanceof And || filter instanceof Or || filter instanceof Not;
    }

    private String mapComparisonFilter(Filter filter) {
        if (filter instanceof IsEqualTo) {
            return this.mapIsEqualTo((IsEqualTo)filter);
        }
        if (filter instanceof IsNotEqualTo) {
            return this.mapIsNotEqualTo((IsNotEqualTo)filter);
        }
        if (filter instanceof IsGreaterThan) {
            return this.mapIsGreaterThan((IsGreaterThan)filter);
        }
        if (filter instanceof IsGreaterThanOrEqualTo) {
            return this.mapIsGreaterThanOrEqualTo((IsGreaterThanOrEqualTo)filter);
        }
        if (filter instanceof IsLessThan) {
            return this.mapIsLessThan((IsLessThan)filter);
        }
        if (filter instanceof IsLessThanOrEqualTo) {
            return this.mapIsLessThanOrEqualTo((IsLessThanOrEqualTo)filter);
        }
        if (filter instanceof IsIn) {
            return this.mapIsIn((IsIn)filter);
        }
        if (filter instanceof IsNotIn) {
            return this.mapIsNotIn((IsNotIn)filter);
        }
        if (filter instanceof ContainsString) {
            return this.mapContainsString((ContainsString)filter);
        }
        if (filter instanceof FullTextContains) {
            return this.mapFullTextContains((FullTextContains)filter);
        }
        if (filter instanceof FullTextContainsAll) {
            return this.mapFullTextContainsAll((FullTextContainsAll)filter);
        }
        if (filter instanceof FullTextContainsAny) {
            return this.mapFullTextContainsAny((FullTextContainsAny)filter);
        }
        throw new UnsupportedOperationException("Unsupported filter type: " + filter.getClass().getName());
    }

    private String getLogicalFormat(Filter filter) {
        if (filter instanceof And) {
            return "(%s AND %s)";
        }
        if (filter instanceof Or) {
            return "(%s OR %s)";
        }
        if (filter instanceof Not) {
            return "(NOT %s)";
        }
        throw new UnsupportedOperationException("Unsupported filter type: " + filter.getClass().getName());
    }

    private String getComparisonFormat(Filter filter) {
        if (filter instanceof IsEqualTo) {
            return "c.%s = %s";
        }
        if (filter instanceof IsGreaterThan) {
            return "c.%s > %s";
        }
        if (filter instanceof IsGreaterThanOrEqualTo) {
            return "c.%s >= %s";
        }
        if (filter instanceof IsLessThan) {
            return "c.%s < %s";
        }
        if (filter instanceof IsLessThanOrEqualTo) {
            return "c.%s <= %s";
        }
        if (filter instanceof ContainsString) {
            return "CONTAINS(c.%s, %s)";
        }
        throw new UnsupportedOperationException("Unsupported filter type: " + filter.getClass().getName());
    }

    private String mapIsEqualTo(IsEqualTo filter) {
        return String.format(this.getComparisonFormat((Filter)filter), filter.key(), this.formatValue(filter.comparisonValue()));
    }

    private String mapIsNotEqualTo(IsNotEqualTo filter) {
        return this.map(Filter.not((Filter)new IsEqualTo(filter.key(), filter.comparisonValue())));
    }

    private String mapIsGreaterThan(IsGreaterThan filter) {
        return String.format(this.getComparisonFormat((Filter)filter), filter.key(), this.formatValue(filter.comparisonValue()));
    }

    private String mapIsGreaterThanOrEqualTo(IsGreaterThanOrEqualTo filter) {
        return String.format(this.getComparisonFormat((Filter)filter), filter.key(), this.formatValue(filter.comparisonValue()));
    }

    private String mapIsLessThan(IsLessThan filter) {
        return String.format(this.getComparisonFormat((Filter)filter), filter.key(), this.formatValue(filter.comparisonValue()));
    }

    private String mapIsLessThanOrEqualTo(IsLessThanOrEqualTo filter) {
        return String.format(this.getComparisonFormat((Filter)filter), filter.key(), this.formatValue(filter.comparisonValue()));
    }

    private String mapIsIn(IsIn filter) {
        String values = this.mapInValues(filter.comparisonValues());
        return String.format("c.%s IN (%s)", filter.key(), values);
    }

    private String mapIsNotIn(IsNotIn filter) {
        return this.map(Filter.not((Filter)new IsIn(filter.key(), filter.comparisonValues())));
    }

    private String mapContainsString(ContainsString filter) {
        return String.format(this.getComparisonFormat((Filter)filter), filter.key(), this.formatValue(filter.comparisonValue()));
    }

    private String mapFullTextContains(FullTextContains filter) {
        return String.format("FullTextContains(c.%s, %s)", filter.key(), this.formatValue(filter.searchTerm()));
    }

    private String mapFullTextContainsAll(FullTextContainsAll filter) {
        String terms = filter.searchTerms().stream().map(this::formatValue).collect(Collectors.joining(", "));
        return String.format("FullTextContainsAll(c.%s, %s)", filter.key(), terms);
    }

    private String mapFullTextContainsAny(FullTextContainsAny filter) {
        String terms = filter.searchTerms().stream().map(this::formatValue).collect(Collectors.joining(", "));
        return String.format("FullTextContainsAny(c.%s, %s)", filter.key(), terms);
    }

    private String mapInValues(Collection<?> comparisonValues) {
        return comparisonValues.stream().map(this::formatValue).sorted().collect(Collectors.joining(", "));
    }

    private String formatValue(Object value) {
        if (value instanceof String) {
            return "\"" + String.valueOf(value) + "\"";
        }
        return value.toString();
    }
}

