/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.agentic.a2a;

import dev.langchain4j.agentic.UntypedAgent;
import dev.langchain4j.agentic.a2a.A2AClientSpecification;
import dev.langchain4j.agentic.agent.AgentRequest;
import dev.langchain4j.agentic.agent.AgentResponse;
import dev.langchain4j.agentic.internal.A2AClientBuilder;
import dev.langchain4j.agentic.internal.AgentSpecification;
import dev.langchain4j.agentic.internal.AgentUtil;
import io.a2a.A2A;
import io.a2a.client.Client;
import io.a2a.client.ClientEvent;
import io.a2a.client.MessageEvent;
import io.a2a.client.TaskEvent;
import io.a2a.client.TaskUpdateEvent;
import io.a2a.client.config.ClientConfig;
import io.a2a.client.transport.jsonrpc.JSONRPCTransport;
import io.a2a.client.transport.jsonrpc.JSONRPCTransportConfig;
import io.a2a.client.transport.spi.ClientTransportConfig;
import io.a2a.spec.A2AClientError;
import io.a2a.spec.A2AClientException;
import io.a2a.spec.AgentCard;
import io.a2a.spec.Message;
import io.a2a.spec.TextPart;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultA2AClientBuilder<T>
implements A2AClientBuilder<T> {
    private final Class<T> agentServiceClass;
    private static final Logger LOG = LoggerFactory.getLogger(DefaultA2AClientBuilder.class);
    private final AgentCard agentCard;
    private final Client a2aClient;
    private String name;
    private String uniqueName;
    private String[] inputNames;
    private String outputName;
    private boolean async;
    private Consumer<AgentRequest> beforeListener = request -> {};
    private Consumer<AgentResponse> afterListener = response -> {};

    DefaultA2AClientBuilder(String a2aServerUrl, Class<T> agentServiceClass) {
        this.agentCard = DefaultA2AClientBuilder.agentCard(a2aServerUrl);
        this.name = this.agentCard.name();
        this.uniqueName = AgentUtil.uniqueAgentName((String)this.name);
        try {
            this.a2aClient = Client.builder((AgentCard)this.agentCard).clientConfig(new ClientConfig.Builder().setStreaming(Boolean.valueOf(false)).build()).withTransport(JSONRPCTransport.class, (ClientTransportConfig)new JSONRPCTransportConfig()).build();
        }
        catch (A2AClientException e) {
            throw new RuntimeException(e);
        }
        this.agentServiceClass = agentServiceClass;
    }

    private static AgentCard agentCard(String a2aServerUrl) {
        try {
            return A2A.getAgentCard((String)a2aServerUrl);
        }
        catch (A2AClientError e) {
            throw new RuntimeException(e);
        }
    }

    public T build() {
        if (this.agentServiceClass == UntypedAgent.class && this.inputNames == null) {
            throw new IllegalArgumentException("Input names must be provided for UntypedAgent.");
        }
        Object agent = Proxy.newProxyInstance(this.agentServiceClass.getClassLoader(), new Class[]{this.agentServiceClass, A2AClientSpecification.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Exception {
                if (method.getDeclaringClass() == AgentSpecification.class) {
                    return switch (method.getName()) {
                        case "name" -> DefaultA2AClientBuilder.this.name;
                        case "uniqueName" -> DefaultA2AClientBuilder.this.uniqueName;
                        case "description" -> DefaultA2AClientBuilder.this.agentCard.description();
                        case "outputName" -> DefaultA2AClientBuilder.this.outputName;
                        case "async" -> DefaultA2AClientBuilder.this.async;
                        case "beforeInvocation" -> {
                            DefaultA2AClientBuilder.this.beforeListener.accept((AgentRequest)args[0]);
                            yield null;
                        }
                        case "afterInvocation" -> {
                            DefaultA2AClientBuilder.this.afterListener.accept((AgentResponse)args[0]);
                            yield null;
                        }
                        default -> throw new UnsupportedOperationException("Unknown method on AgentInstance class : " + method.getName());
                    };
                }
                if (method.getDeclaringClass() == A2AClientSpecification.class) {
                    return switch (method.getName()) {
                        case "agentCard" -> DefaultA2AClientBuilder.this.agentCard;
                        case "inputNames" -> DefaultA2AClientBuilder.this.inputNames;
                        default -> throw new UnsupportedOperationException("Unknown method on A2AClientInstance class : " + method.getName());
                    };
                }
                return DefaultA2AClientBuilder.this.invokeAgent(args);
            }
        });
        return (T)agent;
    }

    private Object invokeAgent(Object[] args) throws A2AClientException {
        ArrayList<TextPart> parts = new ArrayList<TextPart>();
        if (this.agentServiceClass == UntypedAgent.class) {
            Map params = (Map)args[0];
            for (String inputName : this.inputNames) {
                parts.add(new TextPart(params.get(inputName).toString()));
            }
        } else {
            for (Object arg : args) {
                parts.add(new TextPart(arg.toString()));
            }
        }
        Message message = new Message.Builder().role(Message.Role.USER).parts(parts).build();
        CompletableFuture messageResponse = new CompletableFuture();
        List<BiConsumer<ClientEvent, AgentCard>> consumers = List.of((event, card) -> {
            if (event instanceof MessageEvent) {
                MessageEvent messageEvent = (MessageEvent)event;
                messageResponse.complete(messageEvent.getMessage().getParts().stream().filter(TextPart.class::isInstance).map(TextPart.class::cast).map(TextPart::getText).collect(Collectors.joining("\n")));
            } else if (event instanceof TaskEvent) {
                TaskEvent taskEvent = (TaskEvent)event;
                messageResponse.complete(taskEvent.getTask().getArtifacts().stream().flatMap(a -> a.parts().stream()).filter(TextPart.class::isInstance).map(TextPart.class::cast).map(TextPart::getText).collect(Collectors.joining("\n")));
            } else if (event instanceof TaskUpdateEvent) {
                TaskUpdateEvent updateEvent = (TaskUpdateEvent)event;
                if (updateEvent.getTask().getArtifacts() != null) {
                    messageResponse.complete(updateEvent.getTask().getArtifacts().stream().flatMap(a -> a.parts().stream()).filter(TextPart.class::isInstance).map(TextPart.class::cast).map(TextPart::getText).collect(Collectors.joining("\n")));
                }
            } else {
                messageResponse.completeExceptionally(new IllegalArgumentException("The event expected should be of type " + String.valueOf(event.getClass())));
            }
        });
        Consumer<Throwable> streamingErrorHandler = error -> {
            LOG.error("Streaming error occurred: " + error.getMessage(), error);
            messageResponse.completeExceptionally((Throwable)error);
        };
        this.a2aClient.sendMessage(message, consumers, streamingErrorHandler);
        try {
            String responseText = (String)messageResponse.get();
            LOG.debug("Response: " + responseText);
            return responseText;
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.error("Failed to get response: " + e.getMessage(), (Throwable)e);
            throw new RuntimeException("Failed to get response: " + e.getMessage(), e);
        }
    }

    public DefaultA2AClientBuilder<T> inputNames(String ... inputNames) {
        this.inputNames = inputNames;
        return this;
    }

    public DefaultA2AClientBuilder<T> outputName(String outputName) {
        this.outputName = outputName;
        return this;
    }

    public DefaultA2AClientBuilder<T> async(boolean async) {
        this.async = async;
        return this;
    }

    public DefaultA2AClientBuilder<T> beforeAgentInvocation(Consumer<AgentRequest> beforeListener) {
        this.beforeListener = this.beforeListener.andThen(beforeListener);
        return this;
    }

    public DefaultA2AClientBuilder<T> afterAgentInvocation(Consumer<AgentResponse> afterListener) {
        this.afterListener = this.afterListener.andThen(afterListener);
        return this;
    }
}

