/*
 * Decompiled with CFR 0.152.
 */
package dev.krud.crudframework.mongo.dao;

import dev.krud.crudframework.model.BaseCrudEntity;
import dev.krud.crudframework.modelfilter.DynamicModelFilter;
import dev.krud.crudframework.modelfilter.FilterField;
import dev.krud.crudframework.modelfilter.OrderDTO;
import dev.krud.crudframework.modelfilter.enums.FilterFieldOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

public abstract class AbstractMongoBaseDao {
    @Autowired
    protected MongoTemplate mongoTemplate;
    private static final Set<Class<?>> primitiveAndBoxedTypes = new HashSet();

    public <T extends BaseCrudEntity> T findObject(Class<T> clazz, Serializable id) {
        Criteria criteria = Criteria.where((String)"id").is((Object)id);
        return (T)((BaseCrudEntity)this.mongoTemplate.findOne(new Query().addCriteria((CriteriaDefinition)criteria), clazz));
    }

    public <T extends BaseCrudEntity> List<T> findObjectByIds(Class<T> clazz, Serializable[] ids) {
        Criteria criteria = Criteria.where((String)"id").in((Object[])ids);
        return this.mongoTemplate.find(new Query().addCriteria((CriteriaDefinition)criteria), clazz);
    }

    public void deleteObject(Class clazz, Serializable id) {
        this.deleteObject(this.findObject(clazz, id));
    }

    public void deleteObject(Object object) {
        if (null != object) {
            this.mongoTemplate.remove(object);
        }
    }

    protected Query buildQuery(DynamicModelFilter filter) {
        Query query = new Query();
        if (filter != null && filter.getFilterFields() != null && !filter.getFilterFields().isEmpty()) {
            Criteria criteria = new Criteria();
            for (FilterField filterField : filter.getFilterFields()) {
                this.buildCriterion(criteria, filterField);
            }
            query.addCriteria((CriteriaDefinition)criteria);
        }
        return query;
    }

    private Criteria buildCriterion(Criteria criteria, FilterField filterField) {
        if (filterField.getChildren() != null || this.isValidSimpleFilterField(filterField)) {
            switch (filterField.getOperation()) {
                case Equal: {
                    criteria.and(filterField.getFieldName()).is(filterField.getValue1());
                    break;
                }
                case NotEqual: {
                    criteria.and(filterField.getFieldName()).ne(filterField.getValue1());
                    break;
                }
                case In: {
                    criteria.and(filterField.getFieldName()).in(filterField.getValues());
                    break;
                }
                case NotIn: {
                    criteria.and(filterField.getFieldName()).nin(filterField.getValues());
                    break;
                }
                case GreaterEqual: {
                    criteria.and(filterField.getFieldName()).gte(filterField.getValue1());
                    break;
                }
                case GreaterThan: {
                    criteria.and(filterField.getFieldName()).gt(filterField.getValue1());
                    break;
                }
                case LowerEqual: {
                    criteria.and(filterField.getFieldName()).lte(filterField.getValue1());
                    break;
                }
                case LowerThan: {
                    criteria.and(filterField.getFieldName()).lt(filterField.getValue1());
                    break;
                }
                case Between: {
                    criteria.and(filterField.getFieldName()).gte(filterField.getValue1()).and(filterField.getFieldName()).lte(filterField.getValue2());
                    break;
                }
                case Contains: {
                    if (filterField.getValue1() == null || filterField.getValue1().toString().trim().isEmpty()) break;
                    criteria.and(filterField.getFieldName()).regex(Pattern.compile(filterField.getValue1().toString(), 0));
                    break;
                }
                case IsNull: {
                    criteria.orOperator(new Criteria[]{Criteria.where((String)filterField.getFieldName()).exists(false), Criteria.where((String)filterField.getFieldName()).is(null)});
                    break;
                }
                case IsNotNull: {
                    criteria.and(filterField.getFieldName()).ne(null);
                    break;
                }
                case And: {
                    if (filterField.getChildren() == null || filterField.getChildren().isEmpty()) break;
                    ArrayList<Criteria> criterias = new ArrayList<Criteria>();
                    for (FilterField child : filterField.getChildren()) {
                        criterias.add(this.buildCriterion(criteria, child));
                    }
                    criteria.andOperator(criterias.toArray(new Criteria[0]));
                    break;
                }
                case Or: {
                    if (filterField.getChildren() == null || filterField.getChildren().isEmpty()) break;
                    ArrayList<Criteria> criterias = new ArrayList<Criteria>();
                    for (FilterField child : filterField.getChildren()) {
                        criterias.add(this.buildCriterion(criteria, child));
                    }
                    criteria.orOperator(criterias.toArray(new Criteria[0]));
                    break;
                }
                case Not: {
                    if (filterField.getChildren() == null || filterField.getChildren().isEmpty()) break;
                    FilterField child = (FilterField)filterField.getChildren().get(0);
                    criteria.not().andOperator(new Criteria[]{this.buildCriterion(criteria, child)});
                    break;
                }
                case Noop: {
                    criteria.and("id").in(new Object[0]);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported filter operation: " + filterField.getOperation());
                }
            }
        }
        return criteria;
    }

    private boolean isValidSimpleFilterField(FilterField filterField) {
        return filterField.getFieldName() != null && !filterField.getFieldName().trim().isEmpty() && filterField.getOperation() != null && this.areValuesValid(filterField);
    }

    private boolean areValuesValid(FilterField filterField) {
        List<FilterFieldOperation> simpleOperationsWithoutValue = Arrays.asList(FilterFieldOperation.IsNotNull, FilterFieldOperation.IsNull);
        if (simpleOperationsWithoutValue.contains(filterField.getOperation())) {
            return true;
        }
        return filterField.getValues() != null && filterField.getValues().length > 0;
    }

    protected void setOrder(Query query, Set<OrderDTO> orders) {
        ArrayList<Sort.Order> sortOrders = new ArrayList<Sort.Order>();
        for (OrderDTO order : orders) {
            if (order.getBy() == null || order.getBy().trim().isEmpty()) continue;
            sortOrders.add(new Sort.Order(order.getDescending() ? Sort.Direction.DESC : Sort.Direction.ASC, order.getBy()));
        }
        if (!sortOrders.isEmpty()) {
            query.with(Sort.by(sortOrders));
        } else {
            query.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"id"}));
        }
    }

    protected void setBoundaries(Query query, Integer start, Integer limit) {
        if (start != null) {
            query.skip((long)start.intValue());
        }
        if (limit != null) {
            query.limit(limit.intValue());
        }
    }

    protected String replaceSpecialCharacters(String string) {
        return string.replace("_", "\\_").replace("%", "\\%");
    }

    static {
        primitiveAndBoxedTypes.add(Boolean.TYPE);
        primitiveAndBoxedTypes.add(Byte.TYPE);
        primitiveAndBoxedTypes.add(Short.TYPE);
        primitiveAndBoxedTypes.add(Character.TYPE);
        primitiveAndBoxedTypes.add(Integer.TYPE);
        primitiveAndBoxedTypes.add(Long.TYPE);
        primitiveAndBoxedTypes.add(Float.TYPE);
        primitiveAndBoxedTypes.add(Double.TYPE);
        primitiveAndBoxedTypes.add(Boolean.class);
        primitiveAndBoxedTypes.add(Character.class);
        primitiveAndBoxedTypes.add(Byte.class);
        primitiveAndBoxedTypes.add(Short.class);
        primitiveAndBoxedTypes.add(String.class);
        primitiveAndBoxedTypes.add(Integer.class);
        primitiveAndBoxedTypes.add(Long.class);
        primitiveAndBoxedTypes.add(Float.class);
        primitiveAndBoxedTypes.add(Double.class);
    }
}

