/*
 * Decompiled with CFR 0.152.
 */
package dev.krud.crudframework.jpa.dao;

import dev.krud.crudframework.jpa.annotation.CrudJoinType;
import dev.krud.crudframework.jpa.dao.AliasAwareCriteriaDTO;
import dev.krud.crudframework.jpa.dao.BaseDao;
import dev.krud.crudframework.model.BaseCrudEntity;
import dev.krud.crudframework.model.PersistentEntity;
import dev.krud.crudframework.modelfilter.DynamicModelFilter;
import dev.krud.crudframework.modelfilter.FilterField;
import dev.krud.crudframework.modelfilter.OrderDTO;
import dev.krud.crudframework.modelfilter.enums.FilterFieldOperation;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Conjunction;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public abstract class AbstractBaseDao
implements BaseDao {
    @PersistenceContext
    protected EntityManager entityManager;
    private static final Set<Class<?>> PRIMITIVE_AND_BOXED_TYPES = new HashSet();

    protected Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Override
    public <T extends BaseCrudEntity<?>> T findObject(Class<T> clazz, Serializable id) {
        return (T)((BaseCrudEntity)this.getCurrentSession().get(clazz, id));
    }

    public void deleteObject(Class clazz, Serializable id) {
        this.deleteObject(this.findObject(clazz, id));
    }

    public void deleteObject(Object object) {
        if (null != object) {
            this.getCurrentSession().delete(object);
        }
    }

    @Override
    public <T> T saveOrUpdate(T object) {
        this.getCurrentSession().saveOrUpdate(object);
        return object;
    }

    @Override
    public <T> void persist(T object) {
        this.getCurrentSession().persist(object);
    }

    @Override
    public void flush() {
        this.getCurrentSession().flush();
    }

    @Override
    public void clear() {
        this.getCurrentSession().clear();
    }

    protected void setBoundaries(Criteria criteria, Integer start, Integer limit) {
        if (criteria == null) {
            return;
        }
        if (null != start) {
            criteria.setFirstResult(start.intValue());
        }
        if (null != limit) {
            criteria.setMaxResults(limit.intValue());
        }
    }

    protected AliasAwareCriteriaDTO buildCriteria(DynamicModelFilter dynamicModelFilter, Class clazz) {
        Criteria criteria = this.getCurrentSession().createCriteria(clazz);
        ArrayList<String> aliases = new ArrayList<String>();
        if (dynamicModelFilter != null) {
            HashSet<String> flatFilterFieldNames = new HashSet<String>();
            if (dynamicModelFilter.getFilterFields() != null && !dynamicModelFilter.getFilterFields().isEmpty()) {
                this.flattenFilterFieldNames(flatFilterFieldNames, dynamicModelFilter.getFilterFields());
                for (FilterField filterField : dynamicModelFilter.getFilterFields()) {
                    criteria.add(this.buildCriterion(filterField));
                }
            }
            for (OrderDTO order : dynamicModelFilter.getOrders()) {
                flatFilterFieldNames.add(order.getBy());
            }
            this.createAliases(clazz, criteria, aliases, null, flatFilterFieldNames);
        }
        criteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        return new AliasAwareCriteriaDTO(criteria, aliases);
    }

    private void flattenFilterFieldNames(Set<String> flatFilterFieldNames, List<FilterField> filterFields) {
        for (FilterField filterField : filterFields) {
            if (filterField.getFieldName() != null) {
                flatFilterFieldNames.add(filterField.getFieldName());
            }
            if (filterField.getChildren() == null || filterField.getChildren().isEmpty()) continue;
            this.flattenFilterFieldNames(flatFilterFieldNames, filterField.getChildren());
        }
    }

    private Criterion buildCriterion(FilterField filterField) {
        Conjunction junction = Restrictions.and((Criterion[])new Criterion[0]);
        if (filterField.getOperation() == FilterFieldOperation.Noop || filterField.getChildren() != null || this.isValidSimpleFilterField(filterField)) {
            switch (filterField.getOperation()) {
                case Equal: {
                    junction.add((Criterion)Restrictions.eq((String)filterField.getFieldName(), (Object)filterField.getValue1()));
                    break;
                }
                case NotEqual: {
                    junction.add(Restrictions.not((Criterion)Restrictions.eq((String)filterField.getFieldName(), (Object)filterField.getValue1())));
                    break;
                }
                case In: {
                    junction.add(Restrictions.in((String)filterField.getFieldName(), (Object[])filterField.getValues()));
                    break;
                }
                case NotIn: {
                    junction.add(Restrictions.not((Criterion)Restrictions.in((String)filterField.getFieldName(), (Object[])filterField.getValues())));
                    break;
                }
                case GreaterEqual: {
                    junction.add((Criterion)Restrictions.ge((String)filterField.getFieldName(), (Object)filterField.getValue1()));
                    break;
                }
                case GreaterThan: {
                    junction.add((Criterion)Restrictions.gt((String)filterField.getFieldName(), (Object)filterField.getValue1()));
                    break;
                }
                case LowerEqual: {
                    junction.add((Criterion)Restrictions.le((String)filterField.getFieldName(), (Object)filterField.getValue1()));
                    break;
                }
                case LowerThan: {
                    junction.add((Criterion)Restrictions.lt((String)filterField.getFieldName(), (Object)filterField.getValue1()));
                    break;
                }
                case Between: {
                    junction.add(Restrictions.between((String)filterField.getFieldName(), (Object)filterField.getValue1(), (Object)filterField.getValue2()));
                    break;
                }
                case Contains: {
                    if (filterField.getValue1() == null || filterField.getValue1().toString().trim().isEmpty()) break;
                    String valueString = filterField.getValue1().toString();
                    junction.add((Criterion)Restrictions.like((String)filterField.getFieldName(), (String)this.replaceSpecialCharacters(valueString), (MatchMode)MatchMode.ANYWHERE).ignoreCase());
                    break;
                }
                case IsNull: {
                    junction.add(Restrictions.isNull((String)filterField.getFieldName()));
                    break;
                }
                case IsNotNull: {
                    junction.add(Restrictions.isNotNull((String)filterField.getFieldName()));
                    break;
                }
                case IsEmpty: {
                    junction.add(Restrictions.isEmpty((String)filterField.getFieldName()));
                    break;
                }
                case IsNotEmpty: {
                    junction.add(Restrictions.isNotEmpty((String)filterField.getFieldName()));
                    break;
                }
                case And: {
                    if (filterField.getChildren() == null || filterField.getChildren().isEmpty()) break;
                    Conjunction conjunction = Restrictions.and((Criterion[])new Criterion[0]);
                    for (FilterField child : filterField.getChildren()) {
                        conjunction.add(this.buildCriterion(child));
                    }
                    junction.add((Criterion)conjunction);
                    break;
                }
                case Or: {
                    if (filterField.getChildren() == null || filterField.getChildren().isEmpty()) break;
                    Disjunction disjunction = Restrictions.or((Criterion[])new Criterion[0]);
                    for (FilterField child : filterField.getChildren()) {
                        disjunction.add(this.buildCriterion(child));
                    }
                    junction.add((Criterion)disjunction);
                    break;
                }
                case Not: {
                    if (filterField.getChildren() == null || filterField.getChildren().isEmpty()) break;
                    FilterField child = (FilterField)filterField.getChildren().get(0);
                    junction.add(Restrictions.not((Criterion)this.buildCriterion(child)));
                    break;
                }
                case Noop: {
                    junction.add(Restrictions.sqlRestriction((String)"1=0"));
                }
            }
        }
        return junction;
    }

    private boolean isValidSimpleFilterField(FilterField filterField) {
        return filterField.getFieldName() != null && !filterField.getFieldName().trim().isEmpty() && filterField.getOperation() != null && this.areValuesValid(filterField);
    }

    private void createAliases(Class clazz, Criteria criteria, List<String> aliases, String existingAlias, Set<String> flatFilterFieldNames) {
        for (Field field : clazz.getDeclaredFields()) {
            Class type = field.getType();
            boolean isCollection = false;
            if (Collection.class.isAssignableFrom(type)) {
                type = (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
                isCollection = true;
            }
            CrudJoinType crudJoinType = field.getDeclaredAnnotation(CrudJoinType.class);
            Object aliasPath = existingAlias != null ? existingAlias + "." + field.getName() : field.getName();
            if (isCollection && (PRIMITIVE_AND_BOXED_TYPES.contains(type) || Enum.class.isAssignableFrom(type))) {
                if (!flatFilterFieldNames.stream().anyMatch(arg_0 -> AbstractBaseDao.lambda$createAliases$0((String)aliasPath, arg_0))) continue;
                criteria.createAlias((String)aliasPath, (String)aliasPath);
                aliases.add(((String)aliasPath).replace(".", "/"));
                continue;
            }
            if (!PersistentEntity.class.isAssignableFrom(type)) continue;
            String newAlias = ((String)aliasPath).replace(".", "/");
            if (!flatFilterFieldNames.stream().anyMatch(name -> name.startsWith(newAlias + ".") || name.startsWith(newAlias + "/"))) continue;
            if (crudJoinType != null) {
                criteria.createAlias((String)aliasPath, newAlias, crudJoinType.joinType());
            } else {
                criteria.createAlias((String)aliasPath, newAlias);
            }
            aliases.add(((String)aliasPath).replace(".", "/"));
            this.createAliases(type, criteria, aliases, (String)aliasPath, flatFilterFieldNames);
        }
    }

    private boolean areValuesValid(FilterField filterField) {
        List<FilterFieldOperation> simpleOperationsWithoutValue = Arrays.asList(FilterFieldOperation.IsNotNull, FilterFieldOperation.IsNull);
        if (simpleOperationsWithoutValue.contains(filterField.getOperation())) {
            return true;
        }
        return filterField.getValues() != null && filterField.getValues().length > 0;
    }

    protected long getCriteriaCount(Criteria criteria) {
        if (criteria == null) {
            return 0L;
        }
        Object count = criteria.setProjection(Projections.rowCount()).uniqueResult();
        return count == null ? 0L : (Long)count;
    }

    protected Criteria setOrder(Criteria criteria, DynamicModelFilter modelFilter) {
        Set orders = modelFilter.getOrders();
        boolean appliedOrder = false;
        for (OrderDTO order : orders) {
            if (order.getBy() == null || order.getBy().trim().isEmpty()) continue;
            if (order.getDescending()) {
                criteria.addOrder(Order.desc((String)order.getBy()));
            } else {
                criteria.addOrder(Order.asc((String)order.getBy()));
            }
            appliedOrder = true;
        }
        if (!appliedOrder) {
            criteria.addOrder(Order.desc((String)"id"));
        }
        return criteria;
    }

    protected String replaceSpecialCharacters(String string) {
        return string.replace("_", "\\_").replace("%", "\\%");
    }

    private static /* synthetic */ boolean lambda$createAliases$0(String aliasPath, String flatName) {
        return flatName.equals(aliasPath + ".elements");
    }

    static {
        PRIMITIVE_AND_BOXED_TYPES.add(Boolean.TYPE);
        PRIMITIVE_AND_BOXED_TYPES.add(Byte.TYPE);
        PRIMITIVE_AND_BOXED_TYPES.add(Short.TYPE);
        PRIMITIVE_AND_BOXED_TYPES.add(Character.TYPE);
        PRIMITIVE_AND_BOXED_TYPES.add(Integer.TYPE);
        PRIMITIVE_AND_BOXED_TYPES.add(Long.TYPE);
        PRIMITIVE_AND_BOXED_TYPES.add(Float.TYPE);
        PRIMITIVE_AND_BOXED_TYPES.add(Double.TYPE);
        PRIMITIVE_AND_BOXED_TYPES.add(Boolean.class);
        PRIMITIVE_AND_BOXED_TYPES.add(Character.class);
        PRIMITIVE_AND_BOXED_TYPES.add(Byte.class);
        PRIMITIVE_AND_BOXED_TYPES.add(Short.class);
        PRIMITIVE_AND_BOXED_TYPES.add(String.class);
        PRIMITIVE_AND_BOXED_TYPES.add(Integer.class);
        PRIMITIVE_AND_BOXED_TYPES.add(Long.class);
        PRIMITIVE_AND_BOXED_TYPES.add(Float.class);
        PRIMITIVE_AND_BOXED_TYPES.add(Double.class);
    }
}

