/*
 * Decompiled with CFR 0.152.
 */
package dev.krud.crudframework.modelfilter.enums;

import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum FilterFieldDataType {
    String(String.class),
    Integer(Integer.class),
    Long(Long.class),
    Double(Double.class),
    Boolean(Boolean.class),
    Date(Date.class),
    Object(Object.class),
    Enum(Enum.class),
    None;

    private static final Map<Class, FilterFieldDataType> lookup;
    private Class matchingClass = null;

    private FilterFieldDataType(Class matchingClass) {
        this.matchingClass = matchingClass;
    }

    private FilterFieldDataType() {
    }

    public Class getMatchingClass() {
        return this.matchingClass;
    }

    public static FilterFieldDataType get(Class matchingClass) {
        return lookup.get(matchingClass);
    }

    static {
        lookup = new HashMap<Class, FilterFieldDataType>();
        for (FilterFieldDataType dataType : EnumSet.allOf(FilterFieldDataType.class)) {
            lookup.put(dataType.getMatchingClass(), dataType);
        }
    }
}

