/*
 * Decompiled with CFR 0.152.
 */
package dev.krud.crudframework.modelfilter;

import dev.krud.crudframework.modelfilter.enums.FilterFieldDataType;
import dev.krud.crudframework.modelfilter.enums.FilterFieldOperation;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class FilterField
implements Serializable {
    private String fieldName;
    private FilterFieldOperation operation;
    private FilterFieldDataType dataType;
    private String enumType;
    private Object[] values;
    private List<FilterField> children;
    private transient boolean validated = false;

    public FilterField() {
    }

    public FilterField(String fieldName, FilterFieldOperation operation, FilterFieldDataType dataType, List list) {
        this.fieldName = fieldName;
        this.operation = operation;
        this.dataType = dataType;
        this.values = list.toArray();
    }

    public FilterField(String fieldName, FilterFieldOperation operation, FilterFieldDataType dataType, Object ... values) {
        this.fieldName = fieldName;
        this.operation = operation;
        this.dataType = dataType;
        this.values = values;
    }

    public FilterField(String fieldName, FilterFieldOperation operation, String enumType, List list) {
        this.fieldName = fieldName;
        this.operation = operation;
        this.dataType = FilterFieldDataType.Enum;
        this.enumType = enumType;
        this.values = list.toArray();
    }

    public FilterField(String fieldName, FilterFieldOperation operation, String enumType, Object ... values) {
        this.fieldName = fieldName;
        this.operation = operation;
        this.dataType = FilterFieldDataType.Enum;
        this.enumType = enumType;
        this.values = values;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public FilterFieldOperation getOperation() {
        return this.operation;
    }

    public void setOperation(FilterFieldOperation operation) {
        this.operation = operation;
    }

    public FilterFieldDataType getDataType() {
        return this.dataType;
    }

    public void setDataType(FilterFieldDataType dataType) {
        this.dataType = dataType;
    }

    public String getEnumType() {
        return this.enumType;
    }

    public void setEnumType(String enumType) {
        this.enumType = enumType;
    }

    public boolean isValidated() {
        return this.validated;
    }

    public Object[] getValues() {
        if (this.values != null) {
            return Arrays.stream(this.values).map(x -> this.castToType(x)).collect(Collectors.toList()).toArray();
        }
        return null;
    }

    public void setValues(Object[] values) {
        this.values = values;
    }

    public Object getValue1() {
        if (this.values == null || this.values.length == 0) {
            return null;
        }
        return this.castToType(this.values[0]);
    }

    public Object getValue2() {
        if (this.values == null || this.values.length < 2) {
            return null;
        }
        return this.castToType(this.values[1]);
    }

    public List<FilterField> getChildren() {
        return this.children;
    }

    public void setChildren(List<FilterField> children) {
        this.children = children;
    }

    public void validate() {
        this.validated = true;
    }

    public String toString() {
        return "FilterField [fieldName=" + this.fieldName + ", operation=" + this.operation + ", values=" + this.values + "]";
    }

    private Object castToType(Object field) {
        switch (this.dataType) {
            case String: {
                return field.toString();
            }
            case Integer: {
                return Integer.parseInt(field.toString());
            }
            case Long: {
                return Long.parseLong(field.toString());
            }
            case Double: {
                return Double.parseDouble(field.toString());
            }
            case Date: {
                if (field instanceof Date) {
                    return field;
                }
                return new Date(Long.parseLong(field.toString()));
            }
            case Boolean: {
                return Boolean.parseBoolean(field.toString());
            }
            case Object: {
                return field;
            }
            case Enum: {
                if (this.enumType == null || this.enumType.isEmpty()) {
                    throw new RuntimeException("Cannot filter enum without enumType for field - " + this.getFieldName());
                }
                Class<?> clazz = null;
                try {
                    clazz = Class.forName(this.enumType);
                    return Enum.valueOf(clazz, field.toString());
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Could not find class [ " + this.enumType + " ]");
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException("Could not find value [ " + field.toString() + " ] in enum [ " + this.enumType + " ]");
                }
            }
        }
        return field;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilterField that = (FilterField)o;
        return Objects.equals(this.fieldName, that.fieldName) && this.operation == that.operation && this.dataType == that.dataType && Objects.equals(this.enumType, that.enumType) && Arrays.equals(this.values, that.values) && Objects.equals(this.children, that.children);
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.fieldName, this.operation, this.dataType, this.enumType, this.children});
        if (this.operation != null && this.values != null) {
            result = 31 * result + Arrays.hashCode(this.values);
        }
        return result;
    }
}

