/*
 * Decompiled with CFR 0.152.
 */
package dev.krud.crudframework.exception;

import dev.krud.crudframework.exception.WrapException;
import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.full.KClasses;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.core.annotation.AnnotationUtils;

@Aspect
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\u000b"}, d2={"Ldev/krud/crudframework/exception/WrapExceptionAspect;", "", "()V", "invokeExceptionTreeAwareMethod", "pjp", "Lorg/aspectj/lang/ProceedingJoinPoint;", "wrapExceptionAnnotation", "Ldev/krud/crudframework/exception/WrapException;", "methodLevel", "", "typeLevel", "crud-framework-core"})
public final class WrapExceptionAspect {
    @Pointcut(value="@within(wrapExceptionAnnotation)")
    public final void typeLevel(@NotNull WrapException wrapExceptionAnnotation) {
        Intrinsics.checkNotNullParameter((Object)wrapExceptionAnnotation, (String)"wrapExceptionAnnotation");
    }

    @Pointcut(value="@annotation(wrapExceptionAnnotation)")
    public final void methodLevel(@NotNull WrapException wrapExceptionAnnotation) {
        Intrinsics.checkNotNullParameter((Object)wrapExceptionAnnotation, (String)"wrapExceptionAnnotation");
    }

    @Around(value="methodLevel(wrapExceptionAnnotation) || typeLevel(wrapExceptionAnnotation)")
    @Nullable
    public final Object invokeExceptionTreeAwareMethod(@NotNull ProceedingJoinPoint pjp, @Nullable WrapException wrapExceptionAnnotation) throws Throwable {
        Intrinsics.checkNotNullParameter((Object)pjp, (String)"pjp");
        Signature signature = pjp.getSignature();
        Intrinsics.checkNotNull((Object)signature, (String)"null cannot be cast to non-null type org.aspectj.lang.reflect.MethodSignature");
        Method method = ((MethodSignature)signature).getMethod();
        WrapException actualAnnotation = method.getAnnotation(WrapException.class);
        if (actualAnnotation == null) {
            actualAnnotation = (WrapException)AnnotationUtils.findAnnotation((Class)pjp.getSignature().getDeclaringType(), WrapException.class);
        }
        try {
            return pjp.proceed(pjp.getArgs());
        }
        catch (Exception e) {
            Throwable throwable;
            Throwable throwable2;
            KClass exceptionClazz = Reflection.getOrCreateKotlinClass(actualAnnotation.value());
            if (JvmClassMappingKt.getJavaClass((KClass)exceptionClazz).isAssignableFrom(e.getClass())) {
                throw e;
            }
            if (e.getMessage() == null) {
                Object[] objectArray;
                String message = e instanceof NullPointerException ? "Null pointer" : "No message";
                Object object = KClasses.getPrimaryConstructor((KClass)exceptionClazz);
                throwable2 = object != null && (object = (Exception)object.call(objectArray = new Object[]{message})) != null ? ((Throwable)object).initCause(e) : null;
            } else {
                Object[] objectArray;
                Object object = KClasses.getPrimaryConstructor((KClass)exceptionClazz);
                throwable2 = object != null && (object = (Exception)object.call(objectArray = new Object[]{e.getMessage()})) != null ? ((Throwable)object).initCause(e) : (throwable = null);
            }
            if (throwable2 == null) {
                throwable = e;
            }
            Throwable exceptionInstance = throwable;
            throw exceptionInstance;
        }
    }
}

