/*
 * Decompiled with CFR 0.152.
 */
package dev.krud.crudframework.crud.policy;

import dev.krud.crudframework.crud.policy.PolicyElementLocation;
import dev.krud.crudframework.crud.policy.PolicyPostCondition;
import dev.krud.crudframework.crud.policy.PolicyPreCondition;
import dev.krud.crudframework.crud.policy.PolicyRule;
import dev.krud.crudframework.crud.policy.PolicyRuleType;
import dev.krud.crudframework.model.PersistentEntity;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001c*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001\u001cB\u001f\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u0011J8\u0010\u0012\u001a\u00020\u00132\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052$\u0010\u0014\u001a \u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00010\u0016\u0012\u0004\u0012\u00020\u00170\u0015j\b\u0012\u0004\u0012\u00028\u0000`\u0018J,\u0010\u0019\u001a\u00020\u00132\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0018\u0010\u0014\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0016\u0012\u0004\u0012\u00020\u00170\u001aj\u0002`\u001bR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Ldev/krud/crudframework/crud/policy/PolicyRuleBuilder;", "RootType", "Ldev/krud/crudframework/model/PersistentEntity;", "", "name", "", "type", "Ldev/krud/crudframework/crud/policy/PolicyRuleType;", "location", "Ldev/krud/crudframework/crud/policy/PolicyElementLocation;", "(Ljava/lang/String;Ldev/krud/crudframework/crud/policy/PolicyRuleType;Ldev/krud/crudframework/crud/policy/PolicyElementLocation;)V", "postConditions", "", "Ldev/krud/crudframework/crud/policy/PolicyPostCondition;", "preConditions", "Ldev/krud/crudframework/crud/policy/PolicyPreCondition;", "build", "Ldev/krud/crudframework/crud/policy/PolicyRule;", "postCondition", "", "supplier", "Lkotlin/Function2;", "Ljava/security/Principal;", "", "Ldev/krud/crudframework/crud/policy/PolicyPostConditionSupplier;", "preCondition", "Lkotlin/Function1;", "Ldev/krud/crudframework/crud/policy/PolicyPreConditionSupplier;", "Companion", "crud-framework-core"})
public final class PolicyRuleBuilder<RootType extends PersistentEntity> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String name;
    @NotNull
    private final PolicyRuleType type;
    @NotNull
    private final PolicyElementLocation location;
    @NotNull
    private final List<PolicyPreCondition> preConditions;
    @NotNull
    private final List<PolicyPostCondition<RootType>> postConditions;
    @NotNull
    public static final String DEFAULT_RULE_NAME = "unnamed rule";
    @NotNull
    public static final String DEFAULT_PRE_CONDITION_NAME = "unnamed pre condition";
    @NotNull
    public static final String DEFAULT_POST_CONDITION_NAME = "unnamed post condition";

    public PolicyRuleBuilder(@Nullable String name, @NotNull PolicyRuleType type, @NotNull PolicyElementLocation location) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        this.name = name;
        this.type = type;
        this.location = location;
        this.preConditions = new ArrayList();
        this.postConditions = new ArrayList();
    }

    public final void preCondition(@Nullable String name, @NotNull Function1<? super Principal, Boolean> supplier2) {
        Intrinsics.checkNotNullParameter(supplier2, (String)"supplier");
        Collection collection = this.preConditions;
        String string = name;
        if (string == null) {
            string = DEFAULT_PRE_CONDITION_NAME;
        }
        StackTraceElement stackTraceElement = Thread.currentThread().getStackTrace()[2];
        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElement, (String)"Thread.currentThread().stackTrace[2]");
        collection.add(new PolicyPreCondition(string, PolicyElementLocation.Companion.toPolicyElementLocation(stackTraceElement), supplier2));
    }

    public static /* synthetic */ void preCondition$default(PolicyRuleBuilder policyRuleBuilder, String string, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        policyRuleBuilder.preCondition(string, (Function1<Principal, Boolean>)function1);
    }

    public final void postCondition(@Nullable String name, @NotNull Function2<? super RootType, ? super Principal, Boolean> supplier2) {
        Intrinsics.checkNotNullParameter(supplier2, (String)"supplier");
        Collection collection = this.postConditions;
        String string = name;
        if (string == null) {
            string = DEFAULT_POST_CONDITION_NAME;
        }
        StackTraceElement stackTraceElement = Thread.currentThread().getStackTrace()[2];
        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElement, (String)"Thread.currentThread().stackTrace[2]");
        collection.add(new PolicyPostCondition<RootType>(string, PolicyElementLocation.Companion.toPolicyElementLocation(stackTraceElement), supplier2));
    }

    public static /* synthetic */ void postCondition$default(PolicyRuleBuilder policyRuleBuilder, String string, Function2 function2, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        policyRuleBuilder.postCondition(string, function2);
    }

    @NotNull
    public final PolicyRule<RootType> build() {
        String string = this.name;
        if (string == null) {
            string = DEFAULT_RULE_NAME;
        }
        return new PolicyRule<RootType>(string, this.location, this.type, this.preConditions, this.postConditions);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Ldev/krud/crudframework/crud/policy/PolicyRuleBuilder$Companion;", "", "()V", "DEFAULT_POST_CONDITION_NAME", "", "DEFAULT_PRE_CONDITION_NAME", "DEFAULT_RULE_NAME", "crud-framework-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

