/*
 * Decompiled with CFR 0.152.
 */
package dev.krud.crudframework.crud.model;

import dev.krud.crudframework.model.BaseCrudEntity;
import java.util.ArrayList;
import java.util.List;

public abstract class CRUDRequestBuilder<PreHook, OnHook, PostHook, EntityType> {
    protected List<PreHook> preHooks = new ArrayList<PreHook>();
    protected List<OnHook> onHooks = new ArrayList<OnHook>();
    protected List<PostHook> postHooks = new ArrayList<PostHook>();
    protected boolean applyPolicies = false;

    public abstract EntityType execute();

    public final CRUDRequestBuilder<PreHook, OnHook, PostHook, EntityType> withPreHook(PreHook preHook) {
        this.preHooks.add(preHook);
        return this;
    }

    public final CRUDRequestBuilder<PreHook, OnHook, PostHook, EntityType> withOnHook(OnHook onHook) {
        this.onHooks.add(onHook);
        return this;
    }

    public CRUDRequestBuilder<PreHook, OnHook, PostHook, EntityType> enforceAccess(BaseCrudEntity requester) {
        return this;
    }

    public CRUDRequestBuilder<PreHook, OnHook, PostHook, EntityType> enforceAccess(Class<?> requesterType, Long requesterId) {
        return this;
    }

    public CRUDRequestBuilder<PreHook, OnHook, PostHook, EntityType> applyPolicies() {
        this.applyPolicies = true;
        return this;
    }

    public final CRUDRequestBuilder<PreHook, OnHook, PostHook, EntityType> withPostHook(PostHook postHook) {
        this.postHooks.add(postHook);
        return this;
    }
}

