/*
 * Decompiled with CFR 0.152.
 */
package dev.krud.crudframework.crud.handler;

import dev.krud.crudframework.crud.exception.CrudUpdateException;
import dev.krud.crudframework.crud.handler.CrudHelper;
import dev.krud.crudframework.crud.handler.CrudSecurityHandler;
import dev.krud.crudframework.crud.handler.CrudUpdateTransactionalHandler;
import dev.krud.crudframework.crud.hooks.update.CRUDOnUpdateHook;
import dev.krud.crudframework.crud.hooks.update.from.CRUDOnUpdateFromHook;
import dev.krud.crudframework.crud.policy.PolicyRuleType;
import dev.krud.crudframework.model.BaseCrudEntity;
import dev.krud.crudframework.model.PersistentEntity;
import dev.krud.crudframework.modelfilter.DynamicModelFilter;
import java.io.Serializable;
import java.util.List;
import org.springframework.transaction.annotation.Transactional;

public class CrudUpdateTransactionalHandlerImpl
implements CrudUpdateTransactionalHandler {
    private final CrudHelper crudHelper;
    private final CrudSecurityHandler crudSecurityHandler;

    public CrudUpdateTransactionalHandlerImpl(CrudHelper crudHelper, CrudSecurityHandler crudSecurityHandler) {
        this.crudHelper = crudHelper;
        this.crudSecurityHandler = crudSecurityHandler;
    }

    @Override
    @Transactional(readOnly=false)
    public <ID extends Serializable, Entity extends BaseCrudEntity<ID>> Entity updateTransactional(Entity entity, DynamicModelFilter filter2, List<CRUDOnUpdateHook<ID, Entity>> onHooks, boolean applyPolicies) {
        Object existingEntity = this.crudHelper.getEntity(filter2, entity.getClass(), true);
        if (existingEntity == null) {
            throw new CrudUpdateException("Entity of type [ " + entity.getClass().getSimpleName() + " ] does not exist or cannot be updated");
        }
        if (applyPolicies) {
            this.crudSecurityHandler.evaluatePostRulesAndThrow((PersistentEntity)existingEntity, PolicyRuleType.CAN_UPDATE, (Class<? extends PersistentEntity>)entity.getClass());
        }
        for (CRUDOnUpdateHook<ID, Entity> onHook : onHooks) {
            onHook.run(entity);
        }
        this.crudHelper.validate(entity);
        return this.crudHelper.getCrudDaoForEntity(entity.getClass()).saveOrUpdate(entity);
    }

    @Override
    @Transactional(readOnly=false)
    public <ID extends Serializable, Entity extends BaseCrudEntity<ID>> Entity updateFromTransactional(DynamicModelFilter filter2, Object object, Class<Entity> clazz, List<CRUDOnUpdateFromHook<ID, Entity>> onHooks, boolean applyPolicies) {
        Entity entity = this.crudHelper.getEntity(filter2, clazz, null);
        if (entity == null) {
            throw new CrudUpdateException("Entity of type [ " + clazz.getSimpleName() + " ] does not exist or cannot be updated");
        }
        if (applyPolicies) {
            this.crudSecurityHandler.evaluatePostRulesAndThrow((PersistentEntity)entity, PolicyRuleType.CAN_UPDATE, (Class<? extends PersistentEntity>)clazz);
        }
        this.crudHelper.fill(object, entity);
        for (CRUDOnUpdateFromHook<ID, Entity> onHook : onHooks) {
            onHook.run(entity, object);
        }
        this.crudHelper.validate(entity);
        return this.crudHelper.getCrudDaoForEntity(clazz).saveOrUpdate(entity);
    }
}

