/*
 * Decompiled with CFR 0.152.
 */
package dev.krud.crudframework.crud.handler;

import dev.krud.crudframework.crud.handler.CrudSecurityHandler;
import dev.krud.crudframework.crud.handler.CrudSecurityHandlerImpl;
import dev.krud.crudframework.crud.handler.MultiPolicyResult;
import dev.krud.crudframework.crud.policy.Policy;
import dev.krud.crudframework.crud.policy.PolicyRuleType;
import dev.krud.crudframework.crud.security.PrincipalProvider;
import dev.krud.crudframework.model.PersistentEntity;
import dev.krud.crudframework.modelfilter.DynamicModelFilter;
import dev.krud.crudframework.modelfilter.FilterField;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B'\u0012\u0012\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0004\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J \u0010\u0012\u001a\u00020\u00112\u000e\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J(\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u001a2\u000e\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u000eH\u0016J \u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u000e\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u000eH\u0016J\u001e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u000e\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u000eH\u0016J$\u0010\u001f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u001d2\u000e\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u000eH\u0016J\n\u0010 \u001a\u0004\u0018\u00010!H\u0002R\u0012\u0010\n\u001a\u00020\u000b8\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\f\u001a\u001e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Ldev/krud/crudframework/crud/handler/CrudSecurityHandlerImpl;", "Ldev/krud/crudframework/crud/handler/CrudSecurityHandler;", "Lorg/springframework/beans/factory/InitializingBean;", "policies", "Lorg/springframework/beans/factory/ObjectProvider;", "Ldev/krud/crudframework/crud/policy/Policy;", "Ldev/krud/crudframework/model/PersistentEntity;", "principalProvider", "Ldev/krud/crudframework/crud/security/PrincipalProvider;", "(Lorg/springframework/beans/factory/ObjectProvider;Lorg/springframework/beans/factory/ObjectProvider;)V", "applicationContext", "Lorg/springframework/context/ApplicationContext;", "policyMap", "", "Ljava/lang/Class;", "", "afterPropertiesSet", "", "decorateFilter", "clazz", "filter", "Ldev/krud/crudframework/modelfilter/DynamicModelFilter;", "evaluatePostRules", "Ldev/krud/crudframework/crud/handler/MultiPolicyResult;", "entity", "type", "Ldev/krud/crudframework/crud/policy/PolicyRuleType;", "evaluatePreRules", "getFilterFields", "", "Ldev/krud/crudframework/modelfilter/FilterField;", "getPolicies", "getPrincipal", "Ljava/security/Principal;", "crud-framework-core"})
@SourceDebugExtension(value={"SMAP\nCrudSecurityHandlerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CrudSecurityHandlerImpl.kt\ndev/krud/crudframework/crud/handler/CrudSecurityHandlerImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,67:1\n766#2:68\n857#2,2:69\n1855#2,2:71\n1360#2:73\n1446#2,5:74\n1549#2:79\n1620#2,3:80\n1726#2,3:83\n1549#2:86\n1620#2,3:87\n1726#2,3:90\n*S KotlinDebug\n*F\n+ 1 CrudSecurityHandlerImpl.kt\ndev/krud/crudframework/crud/handler/CrudSecurityHandlerImpl\n*L\n33#1:68\n33#1:69,2\n39#1:71,2\n46#1:73\n46#1:74,5\n51#1:79\n51#1:80,3\n54#1:83,3\n60#1:86\n60#1:87,3\n61#1:90,3\n*E\n"})
public final class CrudSecurityHandlerImpl
implements CrudSecurityHandler,
InitializingBean {
    @NotNull
    private final ObjectProvider<Policy<PersistentEntity>> policies;
    @NotNull
    private final ObjectProvider<PrincipalProvider> principalProvider;
    @NotNull
    private final Map<Class<?>, List<Policy<PersistentEntity>>> policyMap;
    @Autowired
    private ApplicationContext applicationContext;

    public CrudSecurityHandlerImpl(@NotNull ObjectProvider<Policy<PersistentEntity>> policies, @NotNull ObjectProvider<PrincipalProvider> principalProvider) {
        Intrinsics.checkNotNullParameter(policies, (String)"policies");
        Intrinsics.checkNotNullParameter(principalProvider, (String)"principalProvider");
        this.policies = policies;
        this.principalProvider = principalProvider;
        this.policyMap = new LinkedHashMap();
    }

    public void afterPropertiesSet() {
        Iterator iterator = this.policies.orderedStream().iterator();
        while (iterator.hasNext()) {
            Policy policy = (Policy)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)policy, (String)"policy");
            this.policyMap.computeIfAbsent(policy.getClazz(), arg_0 -> CrudSecurityHandlerImpl.afterPropertiesSet$lambda$0(afterPropertiesSet.1.INSTANCE, arg_0)).add(policy);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Policy<PersistentEntity>> getPolicies(@NotNull Class<? extends PersistentEntity> clazz) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        ApplicationContext applicationContext = this.applicationContext;
        if (applicationContext == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"applicationContext");
            applicationContext = null;
        }
        Iterable $this$filter$iv = applicationContext.getBeansOfType(Policy.class).values();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Policy it = (Policy)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(it.getClazz(), clazz)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        Intrinsics.checkNotNull((Object)list, (String)"null cannot be cast to non-null type kotlin.collections.List<dev.krud.crudframework.crud.policy.Policy<dev.krud.crudframework.model.PersistentEntity>>");
        return list;
    }

    @Override
    public void decorateFilter(@NotNull Class<? extends PersistentEntity> clazz, @NotNull DynamicModelFilter filter2) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)filter2, (String)"filter");
        PrincipalProvider principalProvider = (PrincipalProvider)this.principalProvider.getIfAvailable();
        Principal principal = principalProvider != null ? principalProvider.getPrincipal() : null;
        Iterable $this$forEach$iv = this.getPolicies(clazz);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Policy policy = (Policy)element$iv;
            boolean bl = false;
            List<FilterField> filterFields = policy.getFilterFields(principal);
            filter2.getFilterFields().addAll((Collection<FilterField>)filterFields);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<FilterField> getFilterFields(@NotNull Class<? extends PersistentEntity> clazz) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Iterable $this$flatMap$iv = this.getPolicies(clazz);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Policy it = (Policy)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getFilterFields(((PrincipalProvider)this.principalProvider.getObject()).getPrincipal());
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public MultiPolicyResult evaluatePreRules(@NotNull PolicyRuleType type, @NotNull Class<? extends PersistentEntity> clazz) {
        boolean bl;
        Class<? extends PersistentEntity> clazz2;
        List results;
        block4: {
            void $this$all$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
            Iterable iterable = this.getPolicies(clazz);
            boolean $i$f$map = false;
            Iterator iterator = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Policy policy = (Policy)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                PrincipalProvider principalProvider = (PrincipalProvider)this.principalProvider.getIfAvailable();
                collection.add(it.evaluatePreRules(type, principalProvider != null ? principalProvider.getPrincipal() : null));
            }
            results = (List)destination$iv$iv;
            $this$map$iv = results;
            clazz2 = clazz;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Policy.Result it = (Policy.Result)element$iv;
                    boolean bl3 = false;
                    if (it.getSuccess()) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        boolean bl4 = bl;
        List list = results;
        boolean bl5 = bl4;
        Class<? extends PersistentEntity> clazz3 = clazz2;
        return new MultiPolicyResult(clazz3, bl5, list);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public MultiPolicyResult evaluatePostRules(@NotNull PersistentEntity entity, @NotNull PolicyRuleType type, @NotNull Class<? extends PersistentEntity> clazz) {
        boolean bl;
        Class<? extends PersistentEntity> clazz2;
        List results;
        block4: {
            void $this$all$iv;
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
            Iterable $this$map$iv = this.getPolicies(clazz);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Policy policy = (Policy)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it.evaluatePostRules(entity, type, ((PrincipalProvider)this.principalProvider.getObject()).getPrincipal()));
            }
            results = (List)destination$iv$iv;
            $this$map$iv = results;
            clazz2 = clazz;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Policy.Result it = (Policy.Result)element$iv;
                    boolean bl3 = false;
                    if (it.getSuccess()) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        boolean bl4 = bl;
        List list = results;
        boolean bl5 = bl4;
        Class<? extends PersistentEntity> clazz3 = clazz2;
        return new MultiPolicyResult(clazz3, bl5, list);
    }

    private final Principal getPrincipal() {
        PrincipalProvider principalProvider = (PrincipalProvider)this.principalProvider.getIfAvailable();
        return principalProvider != null ? principalProvider.getPrincipal() : null;
    }

    @Override
    public void evaluatePreRulesAndThrow(@NotNull PolicyRuleType type, @NotNull Class<? extends PersistentEntity> clazz) {
        CrudSecurityHandler.DefaultImpls.evaluatePreRulesAndThrow(this, type, clazz);
    }

    @Override
    public void evaluatePostRulesAndThrow(@NotNull PersistentEntity entity, @NotNull PolicyRuleType type, @NotNull Class<? extends PersistentEntity> clazz) {
        CrudSecurityHandler.DefaultImpls.evaluatePostRulesAndThrow(this, entity, type, clazz);
    }

    private static final List afterPropertiesSet$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (List)$tmp0.invoke(p0);
    }
}

