/*
 * Decompiled with CFR 0.152.
 */
package dev.krud.crudframework.crud.handler;

import dev.krud.crudframework.crud.handler.CrudHelper;
import dev.krud.crudframework.crud.handler.CrudReadTransactionalHandler;
import dev.krud.crudframework.crud.handler.CrudSecurityHandler;
import dev.krud.crudframework.crud.hooks.index.CRUDOnIndexHook;
import dev.krud.crudframework.crud.hooks.show.CRUDOnShowHook;
import dev.krud.crudframework.crud.hooks.show.by.CRUDOnShowByHook;
import dev.krud.crudframework.crud.policy.PolicyRuleType;
import dev.krud.crudframework.model.BaseCrudEntity;
import dev.krud.crudframework.model.PersistentEntity;
import dev.krud.crudframework.modelfilter.DynamicModelFilter;
import dev.krud.crudframework.ro.PagedResult;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.springframework.transaction.annotation.Transactional;

public class CrudReadTransactionalHandlerImpl
implements CrudReadTransactionalHandler {
    private final CrudHelper crudHelper;
    private final CrudSecurityHandler crudSecurityHandler;

    public CrudReadTransactionalHandlerImpl(CrudHelper crudHelper, CrudSecurityHandler crudSecurityHandler) {
        this.crudHelper = crudHelper;
        this.crudSecurityHandler = crudSecurityHandler;
    }

    @Override
    @Transactional(readOnly=true)
    public <ID extends Serializable, Entity extends BaseCrudEntity<ID>> PagedResult<Entity> indexTransactional(DynamicModelFilter filter2, Class<Entity> clazz, List<CRUDOnIndexHook<ID, Entity>> onHooks, Boolean persistCopy, boolean count, boolean applyPolicies) {
        PagedResult<Object> result;
        if (!count) {
            boolean hasMore;
            List<Entity> entities;
            if (filter2.getLimit() != null) {
                long start;
                filter2.setLimit(filter2.getLimit() + 1L);
                entities = this.crudHelper.getEntities(filter2, clazz, persistCopy);
                if (applyPolicies) {
                    for (BaseCrudEntity entity : entities) {
                        this.crudSecurityHandler.evaluatePostRulesAndThrow(entity, PolicyRuleType.CAN_ACCESS, clazz);
                    }
                }
                hasMore = (long)entities.size() == filter2.getLimit();
                filter2.setLimit(filter2.getLimit() - 1L);
                long l = start = filter2.getStart() == null ? 0L : filter2.getStart();
                if (hasMore) {
                    entities.remove(entities.size() - 1);
                } else {
                    this.crudHelper.setTotalToPagingCache(clazz, filter2, (long)entities.size() + start);
                }
                Long cachedTotal = this.crudHelper.getTotalFromPagingCache(clazz, filter2);
                if (cachedTotal != null) {
                    hasMore = false;
                    total = cachedTotal;
                } else {
                    total = (long)entities.size() + start;
                }
            } else {
                entities = this.crudHelper.getEntities(filter2, clazz, persistCopy);
                hasMore = false;
                total = entities.size();
                this.crudHelper.setTotalToPagingCache(clazz, filter2, total);
            }
            result = new PagedResult<Entity>(filter2.getStart(), filter2.getLimit(), total, hasMore, entities);
        } else {
            total = this.crudHelper.getEntitiesCount(filter2, clazz, false);
            result = new PagedResult(null, null, total, false, Collections.emptyList());
            this.crudHelper.setTotalToPagingCache(clazz, filter2, total);
        }
        for (CRUDOnIndexHook cRUDOnIndexHook : onHooks) {
            cRUDOnIndexHook.run(filter2, result);
        }
        return result;
    }

    @Override
    @Transactional(readOnly=true)
    public <ID extends Serializable, Entity extends BaseCrudEntity<ID>> Entity showByTransactional(DynamicModelFilter filter2, Class<Entity> clazz, List<CRUDOnShowByHook<ID, Entity>> onHooks, Boolean persistCopy, boolean applyPolicies) {
        List<Entity> entities = this.crudHelper.getEntities(filter2, clazz, persistCopy);
        BaseCrudEntity entity = null;
        if (entities.size() > 0) {
            entity = (BaseCrudEntity)entities.get(0);
        }
        if (applyPolicies) {
            this.crudSecurityHandler.evaluatePostRulesAndThrow(entity, PolicyRuleType.CAN_ACCESS, clazz);
        }
        for (CRUDOnShowByHook<ID, BaseCrudEntity> cRUDOnShowByHook : onHooks) {
            cRUDOnShowByHook.run(entity);
        }
        return (Entity)entity;
    }

    @Override
    @Transactional(readOnly=true)
    public <ID extends Serializable, Entity extends BaseCrudEntity<ID>> Entity showTransactional(DynamicModelFilter filter2, Class<Entity> clazz, List<CRUDOnShowHook<ID, Entity>> onHooks, Boolean persistCopy, boolean applyPolicies) {
        Entity entity = this.crudHelper.getEntity(filter2, clazz, persistCopy);
        if (applyPolicies) {
            this.crudSecurityHandler.evaluatePostRulesAndThrow((PersistentEntity)entity, PolicyRuleType.CAN_ACCESS, (Class<? extends PersistentEntity>)clazz);
        }
        for (CRUDOnShowHook<ID, Entity> onHook : onHooks) {
            onHook.run(entity);
        }
        return entity;
    }
}

