/*
 * Decompiled with CFR 0.152.
 */
package dev.krud.crudframework.crud.handler;

import dev.krud.crudframework.crud.cache.CacheUtils;
import dev.krud.crudframework.crud.cache.CrudCache;
import dev.krud.crudframework.crud.exception.CrudReadException;
import dev.krud.crudframework.crud.handler.CrudHelper;
import dev.krud.crudframework.crud.handler.CrudReadHandler;
import dev.krud.crudframework.crud.handler.CrudReadTransactionalHandler;
import dev.krud.crudframework.crud.handler.CrudSecurityHandler;
import dev.krud.crudframework.crud.hooks.HooksDTO;
import dev.krud.crudframework.crud.hooks.index.CRUDOnIndexHook;
import dev.krud.crudframework.crud.hooks.index.CRUDPostIndexHook;
import dev.krud.crudframework.crud.hooks.index.CRUDPreIndexHook;
import dev.krud.crudframework.crud.hooks.interfaces.IndexHooks;
import dev.krud.crudframework.crud.hooks.interfaces.ShowByHooks;
import dev.krud.crudframework.crud.hooks.interfaces.ShowHooks;
import dev.krud.crudframework.crud.hooks.show.CRUDOnShowHook;
import dev.krud.crudframework.crud.hooks.show.CRUDPostShowHook;
import dev.krud.crudframework.crud.hooks.show.CRUDPreShowHook;
import dev.krud.crudframework.crud.hooks.show.by.CRUDOnShowByHook;
import dev.krud.crudframework.crud.hooks.show.by.CRUDPostShowByHook;
import dev.krud.crudframework.crud.hooks.show.by.CRUDPreShowByHook;
import dev.krud.crudframework.crud.policy.PolicyRuleType;
import dev.krud.crudframework.exception.WrapException;
import dev.krud.crudframework.model.BaseCrudEntity;
import dev.krud.crudframework.modelfilter.DynamicModelFilter;
import dev.krud.crudframework.modelfilter.FilterFields;
import dev.krud.crudframework.modelfilter.enums.FilterFieldDataType;
import dev.krud.crudframework.ro.PagedResult;
import java.io.Serializable;
import java.util.List;
import java.util.Random;
import org.springframework.beans.factory.annotation.Autowired;

@WrapException(value=CrudReadException.class)
public class CrudReadHandlerImpl
implements CrudReadHandler {
    @Autowired
    private CrudHelper crudHelper;
    @Autowired
    private CrudReadTransactionalHandler crudReadTransactionalHandler;
    @Autowired
    private CrudSecurityHandler crudSecurityHandler;
    private static Random random = new Random();

    /*
     * WARNING - void declaration
     */
    @Override
    public <ID extends Serializable, Entity extends BaseCrudEntity<ID>> PagedResult<Entity> indexInternal(DynamicModelFilter filter2, Class<Entity> clazz, HooksDTO<CRUDPreIndexHook<ID, Entity>, CRUDOnIndexHook<ID, Entity>, CRUDPostIndexHook<ID, Entity>> hooks, boolean fromCache, Boolean persistCopy, boolean applyPolicies, boolean count) {
        void var10_14;
        if (filter2 == null) {
            filter2 = new DynamicModelFilter();
        }
        if (applyPolicies) {
            this.crudSecurityHandler.evaluatePreRulesAndThrow(PolicyRuleType.CAN_ACCESS, clazz);
            this.crudSecurityHandler.decorateFilter(clazz, filter2);
        }
        this.crudHelper.validateAndFillFilterFieldMetadata(filter2.getFilterFields(), clazz);
        List<IndexHooks> indexHooksList = this.crudHelper.getHooks(IndexHooks.class, clazz);
        if (indexHooksList != null && !indexHooksList.isEmpty()) {
            for (IndexHooks indexHooks : indexHooksList) {
                hooks.getPreHooks().add(0, indexHooks::preIndex);
                hooks.getOnHooks().add(0, indexHooks::onIndex);
                hooks.getPostHooks().add(0, indexHooks::postIndex);
            }
        }
        CrudCache cache = null;
        if (fromCache) {
            cache = this.crudHelper.getEntityCache(clazz);
        }
        for (CRUDPreIndexHook<ID, Entity> preHook : hooks.getPreHooks()) {
            preHook.run(filter2);
        }
        String string = filter2.getCacheKey();
        if (count) {
            String string2 = "count_" + string;
        }
        DynamicModelFilter finalFilter = filter2;
        PagedResult result = (PagedResult)CacheUtils.getObjectAndCache(() -> this.crudReadTransactionalHandler.indexTransactional(finalFilter, clazz, hooks.getOnHooks(), persistCopy, count, applyPolicies), (String)var10_14, cache);
        for (CRUDPostIndexHook<ID, Entity> postHook : hooks.getPostHooks()) {
            postHook.run(filter2, result);
        }
        return result;
    }

    @Override
    public <ID extends Serializable, Entity extends BaseCrudEntity<ID>> Entity showByInternal(DynamicModelFilter filter2, Class<Entity> clazz, HooksDTO<CRUDPreShowByHook<ID, Entity>, CRUDOnShowByHook<ID, Entity>, CRUDPostShowByHook<ID, Entity>> hooks, boolean fromCache, Boolean persistCopy, boolean applyPolicies) {
        if (filter2 == null) {
            filter2 = new DynamicModelFilter();
        }
        if (applyPolicies) {
            this.crudSecurityHandler.evaluatePreRulesAndThrow(PolicyRuleType.CAN_ACCESS, clazz);
            this.crudSecurityHandler.decorateFilter(clazz, filter2);
        }
        this.crudHelper.validateAndFillFilterFieldMetadata(filter2.getFilterFields(), clazz);
        List<ShowByHooks> showByHooksList = this.crudHelper.getHooks(ShowByHooks.class, clazz);
        if (showByHooksList != null && !showByHooksList.isEmpty()) {
            for (ShowByHooks showByHooks : showByHooksList) {
                hooks.getPreHooks().add(0, showByHooks::preShowBy);
                hooks.getOnHooks().add(0, showByHooks::onShowBy);
                hooks.getPostHooks().add(0, showByHooks::postShowBy);
            }
        }
        for (CRUDPreShowByHook cRUDPreShowByHook : hooks.getPreHooks()) {
            cRUDPreShowByHook.run(filter2);
        }
        CrudCache cache = null;
        if (fromCache) {
            cache = this.crudHelper.getEntityCache(clazz);
        }
        DynamicModelFilter dynamicModelFilter = filter2;
        BaseCrudEntity entity = (BaseCrudEntity)CacheUtils.getObjectAndCache(() -> this.crudReadTransactionalHandler.showByTransactional(finalFilter, clazz, hooks.getOnHooks(), persistCopy, applyPolicies), "showBy_" + filter2.hashCode(), cache);
        for (CRUDPostShowByHook<ID, BaseCrudEntity> cRUDPostShowByHook : hooks.getPostHooks()) {
            cRUDPostShowByHook.run(entity);
        }
        return (Entity)entity;
    }

    @Override
    public <ID extends Serializable, Entity extends BaseCrudEntity<ID>> Entity showInternal(ID id, Class<Entity> clazz, HooksDTO<CRUDPreShowHook<ID, Entity>, CRUDOnShowHook<ID, Entity>, CRUDPostShowHook<ID, Entity>> hooks, boolean fromCache, Boolean persistCopy, boolean applyPolicies) {
        List<ShowHooks> showHooksList;
        DynamicModelFilter filter2 = new DynamicModelFilter().add(FilterFields.eq("id", FilterFieldDataType.get(id.getClass()), id));
        if (applyPolicies) {
            this.crudSecurityHandler.evaluatePreRulesAndThrow(PolicyRuleType.CAN_ACCESS, clazz);
            this.crudSecurityHandler.decorateFilter(clazz, filter2);
        }
        if ((showHooksList = this.crudHelper.getHooks(ShowHooks.class, clazz)) != null && !showHooksList.isEmpty()) {
            for (ShowHooks showHooks : showHooksList) {
                hooks.getPreHooks().add(0, showHooks::preShow);
                hooks.getOnHooks().add(0, showHooks::onShow);
                hooks.getPostHooks().add(0, showHooks::postShow);
            }
        }
        for (CRUDPreShowHook cRUDPreShowHook : hooks.getPreHooks()) {
            cRUDPreShowHook.run(id);
        }
        CrudCache cache = null;
        if (fromCache) {
            cache = this.crudHelper.getEntityCache(clazz);
        }
        BaseCrudEntity baseCrudEntity = (BaseCrudEntity)CacheUtils.getObjectAndCache(() -> this.crudReadTransactionalHandler.showTransactional(filter2, clazz, hooks.getOnHooks(), persistCopy, applyPolicies), BaseCrudEntity.Companion.getCacheKey(clazz, id), cache);
        for (CRUDPostShowHook<ID, BaseCrudEntity> cRUDPostShowHook : hooks.getPostHooks()) {
            cRUDPostShowHook.run(baseCrudEntity);
        }
        return (Entity)baseCrudEntity;
    }
}

