/*
 * Decompiled with CFR 0.152.
 */
package dev.krud.crudframework.crud.handler;

import dev.krud.crudframework.FieldUtils;
import dev.krud.crudframework.crud.cache.CacheManagerAdapter;
import dev.krud.crudframework.crud.cache.CacheUtils;
import dev.krud.crudframework.crud.cache.CrudCache;
import dev.krud.crudframework.crud.cache.CrudCacheOptions;
import dev.krud.crudframework.crud.exception.CrudException;
import dev.krud.crudframework.crud.exception.CrudInvalidStateException;
import dev.krud.crudframework.crud.exception.CrudTransformationException;
import dev.krud.crudframework.crud.exception.CrudValidationException;
import dev.krud.crudframework.crud.handler.CrudDao;
import dev.krud.crudframework.crud.handler.CrudHelper;
import dev.krud.crudframework.crud.hooks.interfaces.CRUDHooks;
import dev.krud.crudframework.crud.model.EntityCacheMetadata;
import dev.krud.crudframework.crud.model.EntityMetadataDTO;
import dev.krud.crudframework.exception.WrapException;
import dev.krud.crudframework.exception.dto.ErrorField;
import dev.krud.crudframework.model.BaseCrudEntity;
import dev.krud.crudframework.modelfilter.DynamicModelFilter;
import dev.krud.crudframework.modelfilter.FilterField;
import dev.krud.crudframework.modelfilter.FilterFields;
import dev.krud.crudframework.modelfilter.enums.FilterFieldDataType;
import dev.krud.crudframework.modelfilter.enums.FilterFieldOperation;
import dev.krud.crudframework.util.ReflectionUtils;
import dev.krud.shapeshift.ShapeShift;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.util.ClassUtils;

public class CrudHelperImpl
implements CrudHelper,
InitializingBean {
    private final List<CrudDao> crudDaos;
    private final ApplicationContext applicationContext;
    private final CacheManagerAdapter cacheManagerAdapter;
    private final ShapeShift shapeShift;
    private final Map<Class<? extends BaseCrudEntity<?>>, CrudDao> crudDaoMap = new HashMap();
    private final Map<Class<? extends BaseCrudEntity<?>>, EntityMetadataDTO> entityMetadataDTOs = new ConcurrentHashMap();
    private final Map<String, CrudCache> cacheMap = new HashMap<String, CrudCache>();
    private final Validator validator = Validation.buildDefaultValidatorFactory().getValidator();
    private CrudCache pagingCache;

    public CrudHelperImpl(@Autowired(required=false) List<CrudDao> crudDaos, ApplicationContext applicationContext, CacheManagerAdapter cacheManagerAdapter, ShapeShift shapeShift) {
        this.crudDaos = crudDaos;
        this.applicationContext = applicationContext;
        this.cacheManagerAdapter = cacheManagerAdapter;
        this.shapeShift = shapeShift;
    }

    public void afterPropertiesSet() throws Exception {
        this.pagingCache = this.cacheManagerAdapter.createCache("pagingCache", new CrudCacheOptions(60L, 60L, 10000L));
    }

    @Override
    public <ID extends Serializable, Entity extends BaseCrudEntity<ID>, HooksType extends CRUDHooks> List<HooksType> getHooks(Class<HooksType> crudHooksClazz, Class<Entity> entityClazz) {
        EntityMetadataDTO metadataDTO = this.getEntityMetadata(entityClazz);
        Set matchingAnnotationHooks = metadataDTO.getHooksFromAnnotations().stream().filter(hook -> crudHooksClazz.isAssignableFrom(hook.getClass())).collect(Collectors.toSet());
        List hooks = this.applicationContext.getBeansOfType(crudHooksClazz).values().stream().filter(c -> c.getType() == entityClazz).collect(Collectors.toList());
        hooks.addAll(matchingAnnotationHooks);
        return hooks;
    }

    @Override
    public <ID extends Serializable, Entity extends BaseCrudEntity<ID>> boolean isEntityDeleted(Entity entity) {
        if (entity == null) {
            return true;
        }
        Class<?> clazz = entity.getClass();
        EntityMetadataDTO metadataDTO = this.getEntityMetadata(clazz);
        if (metadataDTO.getDeleteableType() == EntityMetadataDTO.DeleteableType.Hard) {
            return false;
        }
        if (metadataDTO.getDeleteField() == null) {
            return false;
        }
        ReflectionUtils.makeAccessible((Field)metadataDTO.getDeleteField());
        return (Boolean)ReflectionUtils.getField((Field)metadataDTO.getDeleteField(), entity);
    }

    @Override
    public <ID extends Serializable, Entity extends BaseCrudEntity<ID>> void decorateFilter(DynamicModelFilter filter2, Class<Entity> entityClazz) {
        Field deleteField;
        EntityMetadataDTO metadataDTO = this.getEntityMetadata(entityClazz);
        if (metadataDTO.getDeleteableType() == EntityMetadataDTO.DeleteableType.Soft && (deleteField = metadataDTO.getDeleteField()) != null) {
            filter2.add(FilterFields.eq(deleteField.getName(), FilterFieldDataType.Boolean, false));
        }
        this.validateAndFillFilterFieldMetadata(filter2.getFilterFields(), entityClazz);
    }

    @Override
    public <ID extends Serializable, Entity extends BaseCrudEntity<ID>> void validateAndFillFilterFieldMetadata(List<FilterField> filterFields, Class<Entity> entityClazz) {
        EntityMetadataDTO metadataDTO = this.getEntityMetadata(entityClazz);
        for (FilterField filterField : filterFields) {
            boolean isJunction;
            if (filterField.isValidated()) continue;
            if (filterField.getOperation() == null) {
                throw new IllegalStateException("A FilterField must have an operation");
            }
            boolean bl = isJunction = filterField.getOperation() == FilterFieldOperation.And || filterField.getOperation() == FilterFieldOperation.Or || filterField.getOperation() == FilterFieldOperation.Not;
            if (isJunction) {
                if (filterField.getChildren() != null && !filterField.getChildren().isEmpty()) {
                    this.validateAndFillFilterFieldMetadata(filterField.getChildren(), entityClazz);
                }
            } else if (filterField.getFieldName() != null) {
                Class<?> potentialFieldClazz;
                String fieldName = filterField.getFieldName();
                if (fieldName.endsWith(".elements")) {
                    fieldName = fieldName.substring(0, fieldName.lastIndexOf(".elements"));
                }
                if (!metadataDTO.getFields().containsKey(fieldName)) {
                    throw new RuntimeException("Cannot filter field [ " + fieldName + " ] as it was not found on entity [ " + metadataDTO.getSimpleName() + " ]");
                }
                Field field = metadataDTO.getFields().get(fieldName);
                Class<?> fieldClazz = field.getType();
                if (Collection.class.isAssignableFrom(field.getType()) && (potentialFieldClazz = FieldUtils.getGenericClass(field, 0)) != null) {
                    fieldClazz = potentialFieldClazz;
                }
                FilterFieldDataType fieldDataType = this.getDataTypeFromClass(fieldClazz);
                filterField.setDataType(fieldDataType);
                if (fieldDataType == FilterFieldDataType.Enum) {
                    filterField.setEnumType(fieldClazz.getName());
                }
            }
            filterField.validate();
        }
    }

    private FilterFieldDataType getDataTypeFromClass(Class clazz) {
        if (String.class.equals((Object)clazz)) {
            return FilterFieldDataType.String;
        }
        if (Integer.TYPE.equals(clazz) || Integer.class.equals((Object)clazz)) {
            return FilterFieldDataType.Integer;
        }
        if (Long.TYPE.equals(clazz) || Long.class.equals((Object)clazz)) {
            return FilterFieldDataType.Long;
        }
        if (Double.TYPE.equals(clazz) || Double.class.equals((Object)clazz)) {
            return FilterFieldDataType.Double;
        }
        if (Date.class.equals((Object)clazz)) {
            return FilterFieldDataType.Date;
        }
        if (Boolean.TYPE.equals(clazz) || Boolean.class.equals((Object)clazz)) {
            return FilterFieldDataType.Boolean;
        }
        if (Enum.class.isAssignableFrom(clazz)) {
            return FilterFieldDataType.Enum;
        }
        return FilterFieldDataType.Object;
    }

    @Override
    public <ID extends Serializable, Entity extends BaseCrudEntity<ID>> List<Entity> getEntities(DynamicModelFilter filter2, Class<Entity> entityClazz, Boolean persistCopy) {
        this.decorateFilter(filter2, entityClazz);
        if (persistCopy == null) {
            persistCopy = this.getEntityMetadata(entityClazz).getAlwaysPersistCopy();
        }
        List<Entity> result = this.getCrudDaoForEntity(entityClazz).index(filter2, entityClazz);
        if (persistCopy.booleanValue()) {
            result.forEach(BaseCrudEntity::saveOrGetCopy);
        }
        return result;
    }

    @Override
    public <ID extends Serializable, Entity extends BaseCrudEntity<ID>> long getEntitiesCount(DynamicModelFilter filter2, Class<Entity> entityClazz, boolean forUpdate) {
        this.decorateFilter(filter2, entityClazz);
        return this.getCrudDaoForEntity(entityClazz).indexCount(filter2, entityClazz);
    }

    @Override
    public <ID extends Serializable, Entity extends BaseCrudEntity<ID>> Entity getEntity(DynamicModelFilter filter2, Class<Entity> entityClazz, Boolean persistCopy) {
        List<Entity> entities = this.getEntities(filter2, entityClazz, persistCopy);
        BaseCrudEntity entity = null;
        if (entities.size() > 0) {
            entity = (BaseCrudEntity)entities.get(0);
        }
        return (Entity)entity;
    }

    @Override
    public <ID extends Serializable, Entity extends BaseCrudEntity<ID>> long getEntityCountById(ID entityId, Class<Entity> entityClazz, boolean forUpdate) {
        FilterFieldDataType entityIdDataType = FilterFieldDataType.get(entityId.getClass());
        Objects.requireNonNull(entityIdDataType, "Could not assert entityId type");
        DynamicModelFilter filter2 = new DynamicModelFilter().add(FilterFields.eq("id", entityIdDataType, entityId));
        return this.getEntitiesCount(filter2, entityClazz, forUpdate);
    }

    @Override
    public <ID extends Serializable, Entity extends BaseCrudEntity<ID>> void checkEntityImmutability(Class<Entity> clazz) {
        EntityMetadataDTO metadataDTO = this.getEntityMetadata(clazz);
        if (metadataDTO.getImmutable()) {
            throw new CrudInvalidStateException("Entity of type [ " + clazz.getSimpleName() + " ] is immutable");
        }
    }

    @Override
    public <ID extends Serializable, Entity extends BaseCrudEntity<ID>> void checkEntityDeletability(Class<Entity> clazz) {
        EntityMetadataDTO metadataDTO = this.getEntityMetadata(clazz);
        if (metadataDTO.getDeleteableType() == EntityMetadataDTO.DeleteableType.None) {
            throw new CrudInvalidStateException("Entity of type [ " + clazz.getSimpleName() + " ] can not be deleted");
        }
        if (metadataDTO.getDeleteableType() == EntityMetadataDTO.DeleteableType.Soft) {
            if (metadataDTO.getDeleteField() == null) {
                throw new CrudInvalidStateException("Entity of type [ " + clazz.getSimpleName() + " ] is set for soft delete but is missing @DeleteColumn");
            }
            if (!ClassUtils.isAssignable(Boolean.TYPE, metadataDTO.getDeleteField().getType())) {
                throw new CrudInvalidStateException("Entity of type [ " + clazz.getSimpleName() + " ] has an invalid @DeleteColumn - column must be of type boolean");
            }
        }
    }

    @Override
    public <ID extends Serializable, Entity extends BaseCrudEntity<ID>> EntityMetadataDTO getEntityMetadata(Class<Entity> entityClazz) {
        return this.entityMetadataDTOs.computeIfAbsent(entityClazz, x -> {
            EntityMetadataDTO metadataDTO = new EntityMetadataDTO(entityClazz);
            for (Class<CRUDHooks<?, ?>> hookType : metadataDTO.getHookTypesFromAnnotations()) {
                try {
                    CRUDHooks hooks = (CRUDHooks)this.applicationContext.getBean(hookType);
                    metadataDTO.getHooksFromAnnotations().add(hooks);
                }
                catch (BeansException e) {
                    throw new CrudInvalidStateException("Could not get bean for persistent hooks class of type [ " + hookType.getCanonicalName() + " ]. Error: " + e.getMessage());
                }
            }
            return metadataDTO;
        });
    }

    @Override
    public <ID extends Serializable, Entity extends BaseCrudEntity<ID>> void evictEntityFromCache(Entity entity) {
        Objects.requireNonNull(entity, "entity cannot be null");
        CrudCache cache = this.getEntityCache(entity.getClass());
        if (cache == null) {
            return;
        }
        CacheUtils.removeFromCacheIfKeyContains(cache, entity.getCacheKey());
    }

    @Override
    @WrapException(value=CrudException.class)
    public <ID extends Serializable, Entity extends BaseCrudEntity<ID>> CrudCache getEntityCache(Class<Entity> clazz) {
        if (this.cacheMap.containsKey(clazz.getName())) {
            return this.cacheMap.get(clazz.getName());
        }
        EntityMetadataDTO dto = this.getEntityMetadata(clazz);
        EntityCacheMetadata cacheMetadata = dto.getCacheMetadata();
        if (cacheMetadata == null) {
            this.cacheMap.put(clazz.getName(), null);
            return null;
        }
        CrudCache cache = this.cacheManagerAdapter.getCache(cacheMetadata.getName());
        if (cache == null) {
            if (cacheMetadata.getCreateIfMissing()) {
                cache = this.cacheManagerAdapter.createCache(cacheMetadata.getName(), cacheMetadata.getOptions());
            } else {
                throw new CrudException("Cache for entity [ " + clazz.getSimpleName() + " ] with name [ " + dto.getCacheMetadata().getName() + " ] not found");
            }
        }
        this.cacheMap.put(clazz.getName(), cache);
        return cache;
    }

    @Override
    @WrapException(value=CrudValidationException.class)
    public void validate(Object target) {
        Objects.requireNonNull(target, "target cannot be null");
        Set violations = this.validator.validate(target, new Class[0]);
        ArrayList<ErrorField> errorFields = new ArrayList<ErrorField>();
        for (ConstraintViolation violation : violations) {
            errorFields.add(new ErrorField(violation.getPropertyPath().toString(), violation.getMessage(), violation.getConstraintDescriptor().getAttributes()));
        }
        if (!errorFields.isEmpty()) {
            throw new CrudValidationException("Field Validation Failed");
        }
    }

    @Override
    @WrapException(value=CrudTransformationException.class)
    public <From, To> To fill(From fromObject, Class<To> toClazz) {
        Objects.requireNonNull(fromObject, "fromObject cannot be null");
        Objects.requireNonNull(toClazz, "toClazz cannot be null");
        Object toObject = this.shapeShift.map(fromObject, toClazz);
        return (To)toObject;
    }

    @Override
    @WrapException(value=CrudTransformationException.class)
    public <From, To> void fill(From fromObject, To toObject) {
        Objects.requireNonNull(fromObject, "fromObject cannot be null");
        Objects.requireNonNull(toObject, "toObject cannot be null");
        this.shapeShift.map(fromObject, toObject);
    }

    @Override
    @WrapException(value=CrudTransformationException.class)
    public <From, To> List<To> fillMany(List<From> fromObjects, Class<To> toClazz) {
        return this.shapeShift.mapCollection(fromObjects, toClazz);
    }

    @Override
    public <Entity> void setTotalToPagingCache(Class<Entity> entityClazz, DynamicModelFilter filter2, long total) {
        String cacheKey = entityClazz.getName() + "_" + filter2.getFilterFields().hashCode();
        this.pagingCache.put(cacheKey, total);
    }

    @Override
    public <Entity> Long getTotalFromPagingCache(Class<Entity> entityClazz, DynamicModelFilter filter2) {
        String cacheKey = entityClazz.getName() + "_" + filter2.getFilterFields().hashCode();
        return (Long)this.pagingCache.get(cacheKey);
    }

    @Override
    public <ID extends Serializable, Entity extends BaseCrudEntity<ID>> CrudDao getCrudDaoForEntity(Class<Entity> entityClazz) {
        return this.crudDaoMap.computeIfAbsent(entityClazz, x -> {
            Class<? extends CrudDao> entityDaoClazz = this.getEntityMetadata(entityClazz).getDaoClazz();
            for (CrudDao dao : this.crudDaos) {
                if (!this.getTrueProxyClass(dao).equals(entityDaoClazz)) continue;
                return dao;
            }
            return null;
        });
    }

    private <T> Class<T> getTrueProxyClass(T proxy) {
        if (AopUtils.isJdkDynamicProxy(proxy)) {
            try {
                return ((Advised)proxy).getTargetSource().getTarget().getClass();
            }
            catch (Exception e) {
                return null;
            }
        }
        return ClassUtils.getUserClass(proxy.getClass());
    }
}

