/*
 * Decompiled with CFR 0.152.
 */
package dev.krud.crudframework.crud.handler;

import dev.krud.crudframework.crud.cache.CrudCache;
import dev.krud.crudframework.crud.handler.CrudDao;
import dev.krud.crudframework.crud.hooks.interfaces.CRUDHooks;
import dev.krud.crudframework.crud.model.EntityMetadataDTO;
import dev.krud.crudframework.model.BaseCrudEntity;
import dev.krud.crudframework.modelfilter.DynamicModelFilter;
import dev.krud.crudframework.modelfilter.FilterField;
import java.io.Serializable;
import java.util.List;

public interface CrudHelper {
    public <ID extends Serializable, Entity extends BaseCrudEntity<ID>, HooksType extends CRUDHooks> List<HooksType> getHooks(Class<HooksType> var1, Class<Entity> var2);

    public <ID extends Serializable, Entity extends BaseCrudEntity<ID>> boolean isEntityDeleted(Entity var1);

    public <ID extends Serializable, Entity extends BaseCrudEntity<ID>> void decorateFilter(DynamicModelFilter var1, Class<Entity> var2);

    public <ID extends Serializable, Entity extends BaseCrudEntity<ID>> void validateAndFillFilterFieldMetadata(List<FilterField> var1, Class<Entity> var2);

    public <ID extends Serializable, Entity extends BaseCrudEntity<ID>> List<Entity> getEntities(DynamicModelFilter var1, Class<Entity> var2, Boolean var3);

    public <ID extends Serializable, Entity extends BaseCrudEntity<ID>> long getEntitiesCount(DynamicModelFilter var1, Class<Entity> var2, boolean var3);

    public <ID extends Serializable, Entity extends BaseCrudEntity<ID>> Entity getEntity(DynamicModelFilter var1, Class<Entity> var2, Boolean var3);

    public <ID extends Serializable, Entity extends BaseCrudEntity<ID>> long getEntityCountById(ID var1, Class<Entity> var2, boolean var3);

    public <ID extends Serializable, Entity extends BaseCrudEntity<ID>> void checkEntityImmutability(Class<Entity> var1);

    public <ID extends Serializable, Entity extends BaseCrudEntity<ID>> void checkEntityDeletability(Class<Entity> var1);

    public <ID extends Serializable, Entity extends BaseCrudEntity<ID>> EntityMetadataDTO getEntityMetadata(Class<Entity> var1);

    public <ID extends Serializable, Entity extends BaseCrudEntity<ID>> void evictEntityFromCache(Entity var1);

    public <ID extends Serializable, Entity extends BaseCrudEntity<ID>> CrudCache getEntityCache(Class<Entity> var1);

    public void validate(Object var1);

    public <From, To> To fill(From var1, Class<To> var2);

    public <From, To> void fill(From var1, To var2);

    public <From, To> List<To> fillMany(List<From> var1, Class<To> var2);

    public <Entity> void setTotalToPagingCache(Class<Entity> var1, DynamicModelFilter var2, long var3);

    public <Entity> Long getTotalFromPagingCache(Class<Entity> var1, DynamicModelFilter var2);

    public <ID extends Serializable, Entity extends BaseCrudEntity<ID>> CrudDao getCrudDaoForEntity(Class<Entity> var1);
}

