/*
 * Decompiled with CFR 0.152.
 */
package dev.krud.crudframework.crud.handler;

import dev.krud.crudframework.crud.exception.CrudDeleteException;
import dev.krud.crudframework.crud.handler.CrudDeleteTransactionalHandler;
import dev.krud.crudframework.crud.handler.CrudHelper;
import dev.krud.crudframework.crud.handler.CrudSecurityHandler;
import dev.krud.crudframework.crud.hooks.delete.CRUDOnDeleteHook;
import dev.krud.crudframework.crud.policy.PolicyRuleType;
import dev.krud.crudframework.model.BaseCrudEntity;
import dev.krud.crudframework.model.PersistentEntity;
import dev.krud.crudframework.modelfilter.DynamicModelFilter;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.List;
import org.springframework.transaction.annotation.Transactional;

public class CrudDeleteTransactionalHandlerImpl
implements CrudDeleteTransactionalHandler {
    private final CrudHelper crudHelper;
    private final CrudSecurityHandler crudSecurityHandler;

    public CrudDeleteTransactionalHandlerImpl(CrudHelper crudHelper, CrudSecurityHandler crudSecurityHandler) {
        this.crudHelper = crudHelper;
        this.crudSecurityHandler = crudSecurityHandler;
    }

    @Override
    @Transactional(readOnly=false)
    public <ID extends Serializable, Entity extends BaseCrudEntity<ID>> Entity deleteHardTransactional(DynamicModelFilter filter2, Class<Entity> clazz, List<CRUDOnDeleteHook<ID, Entity>> onHooks, boolean applyPolicies) {
        Entity entity = this.getEntityForDeletion(filter2, clazz, applyPolicies);
        for (CRUDOnDeleteHook<ID, Entity> onHook : onHooks) {
            onHook.run(entity);
        }
        this.crudHelper.getCrudDaoForEntity(clazz).hardDeleteById(((BaseCrudEntity)entity).getId(), clazz);
        return entity;
    }

    @Override
    @Transactional(readOnly=false)
    public <ID extends Serializable, Entity extends BaseCrudEntity<ID>> Entity deleteSoftTransactional(DynamicModelFilter filter2, Field deleteField, Class<Entity> clazz, List<CRUDOnDeleteHook<ID, Entity>> onHooks, boolean applyPolicies) {
        Entity entity = this.getEntityForDeletion(filter2, clazz, applyPolicies);
        for (CRUDOnDeleteHook<ID, Entity> onHook : onHooks) {
            onHook.run(entity);
        }
        try {
            deleteField.setAccessible(true);
            deleteField.set(entity, true);
        }
        catch (IllegalAccessException e) {
            CrudDeleteException exception = new CrudDeleteException("Error deleting entity " + clazz.getName());
            exception.initCause(e);
            throw exception;
        }
        return entity;
    }

    private <ID extends Serializable, Entity extends BaseCrudEntity<ID>> Entity getEntityForDeletion(DynamicModelFilter filter2, Class<Entity> clazz, boolean applyPolicies) {
        Entity entity = this.crudHelper.getEntity(filter2, clazz, null);
        if (this.crudHelper.isEntityDeleted(entity)) {
            throw new CrudDeleteException("Entity of type [ " + clazz.getSimpleName() + " ] does not exist or cannot be deleted");
        }
        if (applyPolicies) {
            this.crudSecurityHandler.evaluatePostRulesAndThrow((PersistentEntity)entity, PolicyRuleType.CAN_DELETE, (Class<? extends PersistentEntity>)clazz);
        }
        return entity;
    }
}

