/*
 * Decompiled with CFR 0.152.
 */
package dev.krud.crudframework.crud.handler;

import dev.krud.crudframework.crud.exception.CrudDeleteException;
import dev.krud.crudframework.crud.handler.CrudDeleteHandler;
import dev.krud.crudframework.crud.handler.CrudDeleteTransactionalHandler;
import dev.krud.crudframework.crud.handler.CrudHelper;
import dev.krud.crudframework.crud.handler.CrudSecurityHandler;
import dev.krud.crudframework.crud.hooks.HooksDTO;
import dev.krud.crudframework.crud.hooks.delete.CRUDOnDeleteHook;
import dev.krud.crudframework.crud.hooks.delete.CRUDPostDeleteHook;
import dev.krud.crudframework.crud.hooks.delete.CRUDPreDeleteHook;
import dev.krud.crudframework.crud.hooks.interfaces.DeleteHooks;
import dev.krud.crudframework.crud.model.EntityMetadataDTO;
import dev.krud.crudframework.crud.policy.PolicyRuleType;
import dev.krud.crudframework.exception.WrapException;
import dev.krud.crudframework.model.BaseCrudEntity;
import dev.krud.crudframework.modelfilter.DynamicModelFilter;
import dev.krud.crudframework.modelfilter.FilterFields;
import dev.krud.crudframework.modelfilter.enums.FilterFieldDataType;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

@WrapException(value=CrudDeleteException.class)
public class CrudDeleteHandlerImpl
implements CrudDeleteHandler {
    @Autowired
    private CrudHelper crudHelper;
    @Autowired
    private CrudDeleteTransactionalHandler crudDeleteTransactionalHandler;
    @Autowired
    private CrudSecurityHandler crudSecurityHandler;

    /*
     * WARNING - void declaration
     */
    @Override
    public <ID extends Serializable, Entity extends BaseCrudEntity<ID>> void deleteInternal(ID id, Class<Entity> clazz, HooksDTO<CRUDPreDeleteHook<ID, Entity>, CRUDOnDeleteHook<ID, Entity>, CRUDPostDeleteHook<ID, Entity>> hooks, boolean applyPolicies) {
        void var8_13;
        DynamicModelFilter filter2 = new DynamicModelFilter().add(FilterFields.eq("id", FilterFieldDataType.get(id.getClass()), id));
        if (applyPolicies) {
            this.crudSecurityHandler.evaluatePreRulesAndThrow(PolicyRuleType.CAN_DELETE, clazz);
            this.crudSecurityHandler.decorateFilter(clazz, filter2);
        }
        this.crudHelper.checkEntityImmutability(clazz);
        this.crudHelper.checkEntityDeletability(clazz);
        List<DeleteHooks> deleteHooksList = this.crudHelper.getHooks(DeleteHooks.class, clazz);
        if (deleteHooksList != null && !deleteHooksList.isEmpty()) {
            for (DeleteHooks deleteHooks : deleteHooksList) {
                hooks.getPreHooks().add(0, deleteHooks::preDelete);
                hooks.getOnHooks().add(0, deleteHooks::onDelete);
                hooks.getPostHooks().add(0, deleteHooks::postDelete);
            }
        }
        for (CRUDPreDeleteHook cRUDPreDeleteHook : hooks.getPreHooks()) {
            cRUDPreDeleteHook.run(id);
        }
        EntityMetadataDTO metadataDTO = this.crudHelper.getEntityMetadata(clazz);
        if (metadataDTO.getDeleteableType() == EntityMetadataDTO.DeleteableType.Hard) {
            Entity Entity = this.crudDeleteTransactionalHandler.deleteHardTransactional(filter2, clazz, hooks.getOnHooks(), applyPolicies);
        } else {
            Entity Entity = this.crudDeleteTransactionalHandler.deleteSoftTransactional(filter2, metadataDTO.getDeleteField(), clazz, hooks.getOnHooks(), applyPolicies);
        }
        this.crudHelper.evictEntityFromCache(var8_13);
        for (CRUDPostDeleteHook<ID, void> postHook : hooks.getPostHooks()) {
            postHook.run(var8_13);
        }
    }
}

